<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultListType StructType
 * @subpackage Structs
 */
class FaultListType extends AbstractStructBase
{
    /**
     * The Fault
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Fault
     * @var \StructType\FaultType[]
     */
    public $Fault;
    /**
     * Constructor method for FaultListType
     * @uses FaultListType::setFault()
     * @param \StructType\FaultType[] $fault
     */
    public function __construct(array $fault = array())
    {
        $this
            ->setFault($fault);
    }
    /**
     * Get Fault value
     * @return \StructType\FaultType[]|null
     */
    public function getFault()
    {
        return $this->Fault;
    }
    /**
     * This method is responsible for validating the values passed to the setFault method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFault method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFaultForArrayConstraintsFromSetFault(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $faultListTypeFaultItem) {
            // validation for constraint: itemType
            if (!$faultListTypeFaultItem instanceof \StructType\FaultType) {
                $invalidValues[] = is_object($faultListTypeFaultItem) ? get_class($faultListTypeFaultItem) : sprintf('%s(%s)', gettype($faultListTypeFaultItem), var_export($faultListTypeFaultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fault property can only contain items of type \StructType\FaultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fault value
     * @throws \InvalidArgumentException
     * @param \StructType\FaultType[] $fault
     * @return \StructType\FaultListType
     */
    public function setFault(array $fault = array())
    {
        // validation for constraint: array
        if ('' !== ($faultArrayErrorMessage = self::validateFaultForArrayConstraintsFromSetFault($fault))) {
            throw new \InvalidArgumentException($faultArrayErrorMessage, __LINE__);
        }
        $this->Fault = $fault;
        return $this;
    }
    /**
     * Add item to Fault value
     * @throws \InvalidArgumentException
     * @param \StructType\FaultType $item
     * @return \StructType\FaultListType
     */
    public function addToFault(\StructType\FaultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FaultType) {
            throw new \InvalidArgumentException(sprintf('The Fault property can only contain items of type \StructType\FaultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fault[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaultListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
