<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultDetailsType StructType
 * @subpackage Structs
 */
class FaultDetailsType extends AbstractStructBase
{
    /**
     * The ActivityName
     * Meta information extracted from the WSDL
     * - ref: tns:ActivityName
     * @var string
     */
    public $ActivityName;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Data
     */
    public $Data;
    /**
     * The Msg
     * Meta information extracted from the WSDL
     * - ref: tns:Msg
     * @var string
     */
    public $Msg;
    /**
     * The MsgCode
     * Meta information extracted from the WSDL
     * - ref: tns:MsgCode
     * @var string
     */
    public $MsgCode;
    /**
     * The ProcessStack
     * Meta information extracted from the WSDL
     * - ref: tns:ProcessStack
     * @var string
     */
    public $ProcessStack;
    /**
     * The StackTrace
     * Meta information extracted from the WSDL
     * - ref: tns:StackTrace
     * @var string
     */
    public $StackTrace;
    /**
     * Constructor method for FaultDetailsType
     * @uses FaultDetailsType::setActivityName()
     * @uses FaultDetailsType::setData()
     * @uses FaultDetailsType::setMsg()
     * @uses FaultDetailsType::setMsgCode()
     * @uses FaultDetailsType::setProcessStack()
     * @uses FaultDetailsType::setStackTrace()
     * @param string $activityName
     * @param \StructType\Data $data
     * @param string $msg
     * @param string $msgCode
     * @param string $processStack
     * @param string $stackTrace
     */
    public function __construct($activityName = null, \StructType\Data $data = null, $msg = null, $msgCode = null, $processStack = null, $stackTrace = null)
    {
        $this
            ->setActivityName($activityName)
            ->setData($data)
            ->setMsg($msg)
            ->setMsgCode($msgCode)
            ->setProcessStack($processStack)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get ActivityName value
     * @return string|null
     */
    public function getActivityName()
    {
        return $this->ActivityName;
    }
    /**
     * Set ActivityName value
     * @param string $activityName
     * @return \StructType\FaultDetailsType
     */
    public function setActivityName($activityName = null)
    {
        // validation for constraint: string
        if (!is_null($activityName) && !is_string($activityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityName, true), gettype($activityName)), __LINE__);
        }
        $this->ActivityName = $activityName;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \StructType\Data $data
     * @return \StructType\FaultDetailsType
     */
    public function setData(\StructType\Data $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Msg value
     * @return string|null
     */
    public function getMsg()
    {
        return $this->Msg;
    }
    /**
     * Set Msg value
     * @param string $msg
     * @return \StructType\FaultDetailsType
     */
    public function setMsg($msg = null)
    {
        // validation for constraint: string
        if (!is_null($msg) && !is_string($msg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msg, true), gettype($msg)), __LINE__);
        }
        $this->Msg = $msg;
        return $this;
    }
    /**
     * Get MsgCode value
     * @return string|null
     */
    public function getMsgCode()
    {
        return $this->MsgCode;
    }
    /**
     * Set MsgCode value
     * @param string $msgCode
     * @return \StructType\FaultDetailsType
     */
    public function setMsgCode($msgCode = null)
    {
        // validation for constraint: string
        if (!is_null($msgCode) && !is_string($msgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msgCode, true), gettype($msgCode)), __LINE__);
        }
        $this->MsgCode = $msgCode;
        return $this;
    }
    /**
     * Get ProcessStack value
     * @return string|null
     */
    public function getProcessStack()
    {
        return $this->ProcessStack;
    }
    /**
     * Set ProcessStack value
     * @param string $processStack
     * @return \StructType\FaultDetailsType
     */
    public function setProcessStack($processStack = null)
    {
        // validation for constraint: string
        if (!is_null($processStack) && !is_string($processStack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processStack, true), gettype($processStack)), __LINE__);
        }
        $this->ProcessStack = $processStack;
        return $this;
    }
    /**
     * Get StackTrace value
     * @return string|null
     */
    public function getStackTrace()
    {
        return $this->StackTrace;
    }
    /**
     * Set StackTrace value
     * @param string $stackTrace
     * @return \StructType\FaultDetailsType
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTrace, true), gettype($stackTrace)), __LINE__);
        }
        $this->StackTrace = $stackTrace;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaultDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
