<?php

namespace dpd\Login\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginException StructType
 * Meta information extracted from the WSDL
 * - documentation: Thrown if authentication fails.
 * - type: tns:LoginException
 * @subpackage Structs
 */
class LoginException extends AbstractStructBase
{
    /**
     * The additionalData
     * Meta information extracted from the WSDL
     * - documentation: Additional data for an error.
     * - minOccurs: 0
     * @var string
     */
    public $additionalData;
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - documentation: Additional info for an error in user language.
     * - minOccurs: 0
     * @var string
     */
    public $additionalInfo;
    /**
     * The errorClass
     * Meta information extracted from the WSDL
     * - documentation: The class which creates the error.
     * - minOccurs: 0
     * @var string
     */
    public $errorClass;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - documentation: The error code.
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The fullMessage
     * Meta information extracted from the WSDL
     * - documentation: The complete message text for the error with additional info in user language.
     * - minOccurs: 0
     * @var string
     */
    public $fullMessage;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Language for messages.
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - documentation: The complete message text for the error in user language.
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The shortMessage
     * Meta information extracted from the WSDL
     * - documentation: The short info text for the error in user language.
     * - minOccurs: 0
     * @var string
     */
    public $shortMessage;
    /**
     * The systemFullMessage
     * Meta information extracted from the WSDL
     * - documentation: The complete message text for the error withadditional info in system language.
     * - minOccurs: 0
     * @var string
     */
    public $systemFullMessage;
    /**
     * The systemMessage
     * Meta information extracted from the WSDL
     * - documentation: The complete message text for the error in system language.
     * - minOccurs: 0
     * @var string
     */
    public $systemMessage;
    /**
     * The systemShortMessage
     * Meta information extracted from the WSDL
     * - documentation: The short info text for the error in system language.
     * - minOccurs: 0
     * @var string
     */
    public $systemShortMessage;
    /**
     * Constructor method for LoginException
     * @uses LoginException::setAdditionalData()
     * @uses LoginException::setAdditionalInfo()
     * @uses LoginException::setErrorClass()
     * @uses LoginException::setErrorCode()
     * @uses LoginException::setFullMessage()
     * @uses LoginException::setLanguage()
     * @uses LoginException::setMessage()
     * @uses LoginException::setShortMessage()
     * @uses LoginException::setSystemFullMessage()
     * @uses LoginException::setSystemMessage()
     * @uses LoginException::setSystemShortMessage()
     * @param string $additionalData
     * @param string $additionalInfo
     * @param string $errorClass
     * @param string $errorCode
     * @param string $fullMessage
     * @param string $language
     * @param string $message
     * @param string $shortMessage
     * @param string $systemFullMessage
     * @param string $systemMessage
     * @param string $systemShortMessage
     */
    public function __construct($additionalData = null, $additionalInfo = null, $errorClass = null, $errorCode = null, $fullMessage = null, $language = null, $message = null, $shortMessage = null, $systemFullMessage = null, $systemMessage = null, $systemShortMessage = null)
    {
        $this
            ->setAdditionalData($additionalData)
            ->setAdditionalInfo($additionalInfo)
            ->setErrorClass($errorClass)
            ->setErrorCode($errorCode)
            ->setFullMessage($fullMessage)
            ->setLanguage($language)
            ->setMessage($message)
            ->setShortMessage($shortMessage)
            ->setSystemFullMessage($systemFullMessage)
            ->setSystemMessage($systemMessage)
            ->setSystemShortMessage($systemShortMessage);
    }
    /**
     * Get additionalData value
     * @return string|null
     */
    public function getAdditionalData()
    {
        return $this->additionalData;
    }
    /**
     * Set additionalData value
     * @param string $additionalData
     * @return \dpd\Login\StructType\LoginException
     */
    public function setAdditionalData($additionalData = null)
    {
        // validation for constraint: string
        if (!is_null($additionalData) && !is_string($additionalData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalData, true), gettype($additionalData)), __LINE__);
        }
        $this->additionalData = $additionalData;
        return $this;
    }
    /**
     * Get additionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->additionalInfo;
    }
    /**
     * Set additionalInfo value
     * @param string $additionalInfo
     * @return \dpd\Login\StructType\LoginException
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->additionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get errorClass value
     * @return string|null
     */
    public function getErrorClass()
    {
        return $this->errorClass;
    }
    /**
     * Set errorClass value
     * @param string $errorClass
     * @return \dpd\Login\StructType\LoginException
     */
    public function setErrorClass($errorClass = null)
    {
        // validation for constraint: string
        if (!is_null($errorClass) && !is_string($errorClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorClass, true), gettype($errorClass)), __LINE__);
        }
        $this->errorClass = $errorClass;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \dpd\Login\StructType\LoginException
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get fullMessage value
     * @return string|null
     */
    public function getFullMessage()
    {
        return $this->fullMessage;
    }
    /**
     * Set fullMessage value
     * @param string $fullMessage
     * @return \dpd\Login\StructType\LoginException
     */
    public function setFullMessage($fullMessage = null)
    {
        // validation for constraint: string
        if (!is_null($fullMessage) && !is_string($fullMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullMessage, true), gettype($fullMessage)), __LINE__);
        }
        $this->fullMessage = $fullMessage;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \dpd\Login\StructType\LoginException
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \dpd\Login\StructType\LoginException
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get shortMessage value
     * @return string|null
     */
    public function getShortMessage()
    {
        return $this->shortMessage;
    }
    /**
     * Set shortMessage value
     * @param string $shortMessage
     * @return \dpd\Login\StructType\LoginException
     */
    public function setShortMessage($shortMessage = null)
    {
        // validation for constraint: string
        if (!is_null($shortMessage) && !is_string($shortMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortMessage, true), gettype($shortMessage)), __LINE__);
        }
        $this->shortMessage = $shortMessage;
        return $this;
    }
    /**
     * Get systemFullMessage value
     * @return string|null
     */
    public function getSystemFullMessage()
    {
        return $this->systemFullMessage;
    }
    /**
     * Set systemFullMessage value
     * @param string $systemFullMessage
     * @return \dpd\Login\StructType\LoginException
     */
    public function setSystemFullMessage($systemFullMessage = null)
    {
        // validation for constraint: string
        if (!is_null($systemFullMessage) && !is_string($systemFullMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemFullMessage, true), gettype($systemFullMessage)), __LINE__);
        }
        $this->systemFullMessage = $systemFullMessage;
        return $this;
    }
    /**
     * Get systemMessage value
     * @return string|null
     */
    public function getSystemMessage()
    {
        return $this->systemMessage;
    }
    /**
     * Set systemMessage value
     * @param string $systemMessage
     * @return \dpd\Login\StructType\LoginException
     */
    public function setSystemMessage($systemMessage = null)
    {
        // validation for constraint: string
        if (!is_null($systemMessage) && !is_string($systemMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemMessage, true), gettype($systemMessage)), __LINE__);
        }
        $this->systemMessage = $systemMessage;
        return $this;
    }
    /**
     * Get systemShortMessage value
     * @return string|null
     */
    public function getSystemShortMessage()
    {
        return $this->systemShortMessage;
    }
    /**
     * Set systemShortMessage value
     * @param string $systemShortMessage
     * @return \dpd\Login\StructType\LoginException
     */
    public function setSystemShortMessage($systemShortMessage = null)
    {
        // validation for constraint: string
        if (!is_null($systemShortMessage) && !is_string($systemShortMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemShortMessage, true), gettype($systemShortMessage)), __LINE__);
        }
        $this->systemShortMessage = $systemShortMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Login\StructType\LoginException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
