<?php

namespace dpd\Login\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * Meta information extracted from the WSDL
 * - documentation: Is created when a user logs in and contains its login information.
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The delisId
     * Meta information extracted from the WSDL
     * - documentation: The user's DELIS-Id.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $delisId;
    /**
     * The customerUid
     * Meta information extracted from the WSDL
     * - documentation: The user's customer uid. This is needed for subaccounts, usually this is equal to DELIS-Id
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customerUid;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - documentation: The Authtoken, needed for other web service calls.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authToken;
    /**
     * The depot
     * Meta information extracted from the WSDL
     * - documentation: The depot, to which the user is assigned.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $depot;
    /**
     * Constructor method for Login
     * @uses Login::setDelisId()
     * @uses Login::setCustomerUid()
     * @uses Login::setAuthToken()
     * @uses Login::setDepot()
     * @param string $delisId
     * @param string $customerUid
     * @param string $authToken
     * @param string $depot
     */
    public function __construct($delisId = null, $customerUid = null, $authToken = null, $depot = null)
    {
        $this
            ->setDelisId($delisId)
            ->setCustomerUid($customerUid)
            ->setAuthToken($authToken)
            ->setDepot($depot);
    }
    /**
     * Get delisId value
     * @return string
     */
    public function getDelisId()
    {
        return $this->delisId;
    }
    /**
     * Set delisId value
     * @param string $delisId
     * @return \dpd\Login\StructType\Login
     */
    public function setDelisId($delisId = null)
    {
        // validation for constraint: string
        if (!is_null($delisId) && !is_string($delisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delisId, true), gettype($delisId)), __LINE__);
        }
        $this->delisId = $delisId;
        return $this;
    }
    /**
     * Get customerUid value
     * @return string
     */
    public function getCustomerUid()
    {
        return $this->customerUid;
    }
    /**
     * Set customerUid value
     * @param string $customerUid
     * @return \dpd\Login\StructType\Login
     */
    public function setCustomerUid($customerUid = null)
    {
        // validation for constraint: string
        if (!is_null($customerUid) && !is_string($customerUid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerUid, true), gettype($customerUid)), __LINE__);
        }
        $this->customerUid = $customerUid;
        return $this;
    }
    /**
     * Get authToken value
     * @return string
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \dpd\Login\StructType\Login
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get depot value
     * @return string
     */
    public function getDepot()
    {
        return $this->depot;
    }
    /**
     * Set depot value
     * @param string $depot
     * @return \dpd\Login\StructType\Login
     */
    public function setDepot($depot = null)
    {
        // validation for constraint: string
        if (!is_null($depot) && !is_string($depot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depot, true), gettype($depot)), __LINE__);
        }
        $this->depot = $depot;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Login\StructType\Login
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
