<?php

namespace dpd\Login\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAuth StructType
 * Meta information extracted from the WSDL
 * - documentation: Input parameter of getAuth.
 * - type: tns:getAuth
 * @subpackage Structs
 */
class GetAuth extends AbstractStructBase
{
    /**
     * The delisId
     * Meta information extracted from the WSDL
     * - documentation: The DELIS-Id of the user.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $delisId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: The password of the user.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $password;
    /**
     * The messageLanguage
     * Meta information extracted from the WSDL
     * - documentation: The language (Java format) for messages."de_DE" for german messages."en_US" for english messages.
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minLength: 5
     * - minOccurs: 1
     * @var string
     */
    public $messageLanguage;
    /**
     * Constructor method for getAuth
     * @uses GetAuth::setDelisId()
     * @uses GetAuth::setPassword()
     * @uses GetAuth::setMessageLanguage()
     * @param string $delisId
     * @param string $password
     * @param string $messageLanguage
     */
    public function __construct($delisId = null, $password = null, $messageLanguage = null)
    {
        $this
            ->setDelisId($delisId)
            ->setPassword($password)
            ->setMessageLanguage($messageLanguage);
    }
    /**
     * Get delisId value
     * @return string
     */
    public function getDelisId()
    {
        return $this->delisId;
    }
    /**
     * Set delisId value
     * @param string $delisId
     * @return \dpd\Login\StructType\GetAuth
     */
    public function setDelisId($delisId = null)
    {
        // validation for constraint: string
        if (!is_null($delisId) && !is_string($delisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delisId, true), gettype($delisId)), __LINE__);
        }
        $this->delisId = $delisId;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \dpd\Login\StructType\GetAuth
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get messageLanguage value
     * @return string
     */
    public function getMessageLanguage()
    {
        return $this->messageLanguage;
    }
    /**
     * Set messageLanguage value
     * @param string $messageLanguage
     * @return \dpd\Login\StructType\GetAuth
     */
    public function setMessageLanguage($messageLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($messageLanguage) && !is_string($messageLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageLanguage, true), gettype($messageLanguage)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($messageLanguage) && mb_strlen($messageLanguage) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($messageLanguage)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($messageLanguage) && mb_strlen($messageLanguage) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($messageLanguage)), __LINE__);
        }
        $this->messageLanguage = $messageLanguage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Login\StructType\GetAuth
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
