<?php

namespace dpd\Login\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authentication StructType
 * Meta information extracted from the WSDL
 * - documentation: The data structure for authentication data.
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The delisId
     * Meta information extracted from the WSDL
     * - documentation: The delis user id for authentication.
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 8
     * - minOccurs: 1
     * @var string
     */
    public $delisId;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - documentation: The token for authentication. Field authToken of Login, as a result ofMethod "getAuth" of LoginService.
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $authToken;
    /**
     * The messageLanguage
     * Meta information extracted from the WSDL
     * - documentation: The language (Java format) for messages."de_DE" for german messages."en_US" for english messages.
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minLength: 5
     * - minOccurs: 1
     * @var string
     */
    public $messageLanguage;
    /**
     * Constructor method for authentication
     * @uses Authentication::setDelisId()
     * @uses Authentication::setAuthToken()
     * @uses Authentication::setMessageLanguage()
     * @param string $delisId
     * @param string $authToken
     * @param string $messageLanguage
     */
    public function __construct($delisId = null, $authToken = null, $messageLanguage = null)
    {
        $this
            ->setDelisId($delisId)
            ->setAuthToken($authToken)
            ->setMessageLanguage($messageLanguage);
    }
    /**
     * Get delisId value
     * @return string
     */
    public function getDelisId()
    {
        return $this->delisId;
    }
    /**
     * Set delisId value
     * @param string $delisId
     * @return \dpd\Login\StructType\Authentication
     */
    public function setDelisId($delisId = null)
    {
        // validation for constraint: string
        if (!is_null($delisId) && !is_string($delisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delisId, true), gettype($delisId)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($delisId) && mb_strlen($delisId) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($delisId)), __LINE__);
        }
        // validation for constraint: minLength(8)
        if (!is_null($delisId) && mb_strlen($delisId) < 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 8', mb_strlen($delisId)), __LINE__);
        }
        $this->delisId = $delisId;
        return $this;
    }
    /**
     * Get authToken value
     * @return string
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \dpd\Login\StructType\Authentication
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($authToken) && mb_strlen($authToken) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($authToken)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($authToken) && mb_strlen($authToken) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get messageLanguage value
     * @return string
     */
    public function getMessageLanguage()
    {
        return $this->messageLanguage;
    }
    /**
     * Set messageLanguage value
     * @param string $messageLanguage
     * @return \dpd\Login\StructType\Authentication
     */
    public function setMessageLanguage($messageLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($messageLanguage) && !is_string($messageLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageLanguage, true), gettype($messageLanguage)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($messageLanguage) && mb_strlen($messageLanguage) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($messageLanguage)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($messageLanguage) && mb_strlen($messageLanguage) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($messageLanguage)), __LINE__);
        }
        $this->messageLanguage = $messageLanguage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Login\StructType\Authentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
