<?php

namespace dpd\Login\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAuth
     * Meta information extracted from the WSDL
     * - documentation: Creates an authentication token for the committed user if user name and password are valid.The authentication token is needed for accessing other DPD Web Services.Sample request:SOAP:<soapenv:Envelope
     * xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns="http://dpd.com/common/service/types/LoginService/2.0"> <soapenv:Header/> <soapenv:Body> <ns:getAuth> <delisId><your delisId></delisId> <password><your password></password>
     * <messageLanguage>de_DE</messageLanguage> </ns:getAuth> </soapenv:Body><soapenv:Envelope>REST:URL: <server:port><path>/LoginService/V2_0/getAuthJSON-Data for POST-Request (for GET-Request data must send with parameter "request" and forJSONP the
     * Parameter "jsonpcallback" can be used, to send a padding function name):{ "delisId" : "<your delisId>", "password": "<your password>", "messageLanguage":"en_EN"}REST-Result, without error:{ "getAuthResponse": {"return": { "delisId": "<your delisId>",
     * "customerUid": "<your customerUid>", "authToken": "<your authentication token>", "depot": "<your customerUid>" }}, "status": { "type": "OK", "code": "200", "message": "valid" }}REST-Result, if an error occurred:{"status": { "type":
     * "AuthenticationFault", "code": "<Error code, e.g. LOGIN_8>", "message": "<Error message, e.g. The combination of user and password is invalid.>"}}Additional REST-State on system error:Error-Code: 100Error-Type: SystemFaultError-Message: <Message,
     * which describe the error> | Error codes: | Creates an authentication token for the committed user if user name and password are valid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dpd\Login\StructType\GetAuth $parameters
     * @return \dpd\Login\StructType\GetAuthResponse|bool
     */
    public function getAuth(\dpd\Login\StructType\GetAuth $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAuth($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dpd\Login\StructType\GetAuthResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
