<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoSubscriptionInfo StructType
 * @subpackage Structs
 */
class DtoSubscriptionInfo extends AbstractStructBase
{
    /**
     * The consumption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $consumption;
    /**
     * The countOfReference
     * @var int
     */
    public $countOfReference;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dtoSubscriptionDeliveredInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoSubscriptionDeliveredInfo[]
     */
    public $dtoSubscriptionDeliveredInfos;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The numberOfRequest
     * @var int
     */
    public $numberOfRequest;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceFullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceFullName;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The serviceInterfaceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceInterfaceName;
    /**
     * The serviceNationalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceNationalNumber;
    /**
     * The serviceShortName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceShortName;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The typeId
     * @var int
     */
    public $typeId;
    /**
     * Constructor method for dtoSubscriptionInfo
     * @uses DtoSubscriptionInfo::setConsumption()
     * @uses DtoSubscriptionInfo::setCountOfReference()
     * @uses DtoSubscriptionInfo::setDescription()
     * @uses DtoSubscriptionInfo::setDtoSubscriptionDeliveredInfos()
     * @uses DtoSubscriptionInfo::setId()
     * @uses DtoSubscriptionInfo::setNumberOfRequest()
     * @uses DtoSubscriptionInfo::setServiceDescription()
     * @uses DtoSubscriptionInfo::setServiceFullName()
     * @uses DtoSubscriptionInfo::setServiceId()
     * @uses DtoSubscriptionInfo::setServiceInterfaceName()
     * @uses DtoSubscriptionInfo::setServiceNationalNumber()
     * @uses DtoSubscriptionInfo::setServiceShortName()
     * @uses DtoSubscriptionInfo::setStatus()
     * @uses DtoSubscriptionInfo::setTypeId()
     * @param string $consumption
     * @param int $countOfReference
     * @param string $description
     * @param \StructType\DtoSubscriptionDeliveredInfo[] $dtoSubscriptionDeliveredInfos
     * @param int $id
     * @param int $numberOfRequest
     * @param string $serviceDescription
     * @param string $serviceFullName
     * @param int $serviceId
     * @param string $serviceInterfaceName
     * @param string $serviceNationalNumber
     * @param string $serviceShortName
     * @param string $status
     * @param int $typeId
     */
    public function __construct($consumption = null, $countOfReference = null, $description = null, array $dtoSubscriptionDeliveredInfos = array(), $id = null, $numberOfRequest = null, $serviceDescription = null, $serviceFullName = null, $serviceId = null, $serviceInterfaceName = null, $serviceNationalNumber = null, $serviceShortName = null, $status = null, $typeId = null)
    {
        $this
            ->setConsumption($consumption)
            ->setCountOfReference($countOfReference)
            ->setDescription($description)
            ->setDtoSubscriptionDeliveredInfos($dtoSubscriptionDeliveredInfos)
            ->setId($id)
            ->setNumberOfRequest($numberOfRequest)
            ->setServiceDescription($serviceDescription)
            ->setServiceFullName($serviceFullName)
            ->setServiceId($serviceId)
            ->setServiceInterfaceName($serviceInterfaceName)
            ->setServiceNationalNumber($serviceNationalNumber)
            ->setServiceShortName($serviceShortName)
            ->setStatus($status)
            ->setTypeId($typeId);
    }
    /**
     * Get consumption value
     * @return string|null
     */
    public function getConsumption()
    {
        return $this->consumption;
    }
    /**
     * Set consumption value
     * @param string $consumption
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: string
        if (!is_null($consumption) && !is_string($consumption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->consumption = $consumption;
        return $this;
    }
    /**
     * Get countOfReference value
     * @return int|null
     */
    public function getCountOfReference()
    {
        return $this->countOfReference;
    }
    /**
     * Set countOfReference value
     * @param int $countOfReference
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setCountOfReference($countOfReference = null)
    {
        // validation for constraint: int
        if (!is_null($countOfReference) && !(is_int($countOfReference) || ctype_digit($countOfReference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countOfReference, true), gettype($countOfReference)), __LINE__);
        }
        $this->countOfReference = $countOfReference;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dtoSubscriptionDeliveredInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoSubscriptionDeliveredInfo[]|null
     */
    public function getDtoSubscriptionDeliveredInfos()
    {
        return isset($this->dtoSubscriptionDeliveredInfos) ? $this->dtoSubscriptionDeliveredInfos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDtoSubscriptionDeliveredInfos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtoSubscriptionDeliveredInfos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtoSubscriptionDeliveredInfosForArrayConstraintsFromSetDtoSubscriptionDeliveredInfos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoSubscriptionInfoDtoSubscriptionDeliveredInfosItem) {
            // validation for constraint: itemType
            if (!$dtoSubscriptionInfoDtoSubscriptionDeliveredInfosItem instanceof \StructType\DtoSubscriptionDeliveredInfo) {
                $invalidValues[] = is_object($dtoSubscriptionInfoDtoSubscriptionDeliveredInfosItem) ? get_class($dtoSubscriptionInfoDtoSubscriptionDeliveredInfosItem) : sprintf('%s(%s)', gettype($dtoSubscriptionInfoDtoSubscriptionDeliveredInfosItem), var_export($dtoSubscriptionInfoDtoSubscriptionDeliveredInfosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtoSubscriptionDeliveredInfos property can only contain items of type \StructType\DtoSubscriptionDeliveredInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtoSubscriptionDeliveredInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionDeliveredInfo[] $dtoSubscriptionDeliveredInfos
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setDtoSubscriptionDeliveredInfos(array $dtoSubscriptionDeliveredInfos = array())
    {
        // validation for constraint: array
        if ('' !== ($dtoSubscriptionDeliveredInfosArrayErrorMessage = self::validateDtoSubscriptionDeliveredInfosForArrayConstraintsFromSetDtoSubscriptionDeliveredInfos($dtoSubscriptionDeliveredInfos))) {
            throw new \InvalidArgumentException($dtoSubscriptionDeliveredInfosArrayErrorMessage, __LINE__);
        }
        if (is_null($dtoSubscriptionDeliveredInfos) || (is_array($dtoSubscriptionDeliveredInfos) && empty($dtoSubscriptionDeliveredInfos))) {
            unset($this->dtoSubscriptionDeliveredInfos);
        } else {
            $this->dtoSubscriptionDeliveredInfos = $dtoSubscriptionDeliveredInfos;
        }
        return $this;
    }
    /**
     * Add item to dtoSubscriptionDeliveredInfos value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionDeliveredInfo $item
     * @return \StructType\DtoSubscriptionInfo
     */
    public function addToDtoSubscriptionDeliveredInfos(\StructType\DtoSubscriptionDeliveredInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoSubscriptionDeliveredInfo) {
            throw new \InvalidArgumentException(sprintf('The dtoSubscriptionDeliveredInfos property can only contain items of type \StructType\DtoSubscriptionDeliveredInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtoSubscriptionDeliveredInfos[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get numberOfRequest value
     * @return int|null
     */
    public function getNumberOfRequest()
    {
        return $this->numberOfRequest;
    }
    /**
     * Set numberOfRequest value
     * @param int $numberOfRequest
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setNumberOfRequest($numberOfRequest = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRequest) && !(is_int($numberOfRequest) || ctype_digit($numberOfRequest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfRequest, true), gettype($numberOfRequest)), __LINE__);
        }
        $this->numberOfRequest = $numberOfRequest;
        return $this;
    }
    /**
     * Get serviceDescription value
     * @return string|null
     */
    public function getServiceDescription()
    {
        return $this->serviceDescription;
    }
    /**
     * Set serviceDescription value
     * @param string $serviceDescription
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDescription, true), gettype($serviceDescription)), __LINE__);
        }
        $this->serviceDescription = $serviceDescription;
        return $this;
    }
    /**
     * Get serviceFullName value
     * @return string|null
     */
    public function getServiceFullName()
    {
        return $this->serviceFullName;
    }
    /**
     * Set serviceFullName value
     * @param string $serviceFullName
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setServiceFullName($serviceFullName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceFullName) && !is_string($serviceFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceFullName, true), gettype($serviceFullName)), __LINE__);
        }
        $this->serviceFullName = $serviceFullName;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get serviceInterfaceName value
     * @return string|null
     */
    public function getServiceInterfaceName()
    {
        return $this->serviceInterfaceName;
    }
    /**
     * Set serviceInterfaceName value
     * @param string $serviceInterfaceName
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setServiceInterfaceName($serviceInterfaceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInterfaceName) && !is_string($serviceInterfaceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceInterfaceName, true), gettype($serviceInterfaceName)), __LINE__);
        }
        $this->serviceInterfaceName = $serviceInterfaceName;
        return $this;
    }
    /**
     * Get serviceNationalNumber value
     * @return string|null
     */
    public function getServiceNationalNumber()
    {
        return $this->serviceNationalNumber;
    }
    /**
     * Set serviceNationalNumber value
     * @param string $serviceNationalNumber
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setServiceNationalNumber($serviceNationalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serviceNationalNumber) && !is_string($serviceNationalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceNationalNumber, true), gettype($serviceNationalNumber)), __LINE__);
        }
        $this->serviceNationalNumber = $serviceNationalNumber;
        return $this;
    }
    /**
     * Get serviceShortName value
     * @return string|null
     */
    public function getServiceShortName()
    {
        return $this->serviceShortName;
    }
    /**
     * Set serviceShortName value
     * @param string $serviceShortName
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setServiceShortName($serviceShortName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceShortName) && !is_string($serviceShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceShortName, true), gettype($serviceShortName)), __LINE__);
        }
        $this->serviceShortName = $serviceShortName;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get typeId value
     * @return int|null
     */
    public function getTypeId()
    {
        return $this->typeId;
    }
    /**
     * Set typeId value
     * @param int $typeId
     * @return \StructType\DtoSubscriptionInfo
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: int
        if (!is_null($typeId) && !(is_int($typeId) || ctype_digit($typeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoSubscriptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
