<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoPrintCodeWrapper StructType
 * @subpackage Structs
 */
class DtoPrintCodeWrapper extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $additionalInfo;
    /**
     * The printCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $printCodes;
    /**
     * The resultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultMessage;
    /**
     * Constructor method for dtoPrintCodeWrapper
     * @uses DtoPrintCodeWrapper::setAdditionalInfo()
     * @uses DtoPrintCodeWrapper::setPrintCodes()
     * @uses DtoPrintCodeWrapper::setResultMessage()
     * @param string[] $additionalInfo
     * @param string[] $printCodes
     * @param string $resultMessage
     */
    public function __construct(array $additionalInfo = array(), array $printCodes = array(), $resultMessage = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setPrintCodes($printCodes)
            ->setResultMessage($resultMessage);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoPrintCodeWrapperAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!is_string($dtoPrintCodeWrapperAdditionalInfoItem)) {
                $invalidValues[] = is_object($dtoPrintCodeWrapperAdditionalInfoItem) ? get_class($dtoPrintCodeWrapperAdditionalInfoItem) : sprintf('%s(%s)', gettype($dtoPrintCodeWrapperAdditionalInfoItem), var_export($dtoPrintCodeWrapperAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $additionalInfo
     * @return \StructType\DtoPrintCodeWrapper
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to additionalInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoPrintCodeWrapper
     */
    public function addToAdditionalInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInfo[] = $item;
        return $this;
    }
    /**
     * Get printCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPrintCodes()
    {
        return isset($this->printCodes) ? $this->printCodes : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrintCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrintCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrintCodesForArrayConstraintsFromSetPrintCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoPrintCodeWrapperPrintCodesItem) {
            // validation for constraint: itemType
            if (!is_string($dtoPrintCodeWrapperPrintCodesItem)) {
                $invalidValues[] = is_object($dtoPrintCodeWrapperPrintCodesItem) ? get_class($dtoPrintCodeWrapperPrintCodesItem) : sprintf('%s(%s)', gettype($dtoPrintCodeWrapperPrintCodesItem), var_export($dtoPrintCodeWrapperPrintCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The printCodes property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set printCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $printCodes
     * @return \StructType\DtoPrintCodeWrapper
     */
    public function setPrintCodes(array $printCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($printCodesArrayErrorMessage = self::validatePrintCodesForArrayConstraintsFromSetPrintCodes($printCodes))) {
            throw new \InvalidArgumentException($printCodesArrayErrorMessage, __LINE__);
        }
        if (is_null($printCodes) || (is_array($printCodes) && empty($printCodes))) {
            unset($this->printCodes);
        } else {
            $this->printCodes = $printCodes;
        }
        return $this;
    }
    /**
     * Add item to printCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoPrintCodeWrapper
     */
    public function addToPrintCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The printCodes property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->printCodes[] = $item;
        return $this;
    }
    /**
     * Get resultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->resultMessage;
    }
    /**
     * Set resultMessage value
     * @param string $resultMessage
     * @return \StructType\DtoPrintCodeWrapper
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->resultMessage = $resultMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoPrintCodeWrapper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
