<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoPartnerInfoWrapper StructType
 * @subpackage Structs
 */
class DtoPartnerInfoWrapper extends AbstractStructBase
{
    /**
     * The dtoContractPartyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DtoContractPartyInfo
     */
    public $dtoContractPartyInfo;
    /**
     * The dtoPartnerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DtoPartnerInfo
     */
    public $dtoPartnerInfo;
    /**
     * The result
     * @var int
     */
    public $result;
    /**
     * The resultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultMessage;
    /**
     * Constructor method for dtoPartnerInfoWrapper
     * @uses DtoPartnerInfoWrapper::setDtoContractPartyInfo()
     * @uses DtoPartnerInfoWrapper::setDtoPartnerInfo()
     * @uses DtoPartnerInfoWrapper::setResult()
     * @uses DtoPartnerInfoWrapper::setResultMessage()
     * @param \StructType\DtoContractPartyInfo $dtoContractPartyInfo
     * @param \StructType\DtoPartnerInfo $dtoPartnerInfo
     * @param int $result
     * @param string $resultMessage
     */
    public function __construct(\StructType\DtoContractPartyInfo $dtoContractPartyInfo = null, \StructType\DtoPartnerInfo $dtoPartnerInfo = null, $result = null, $resultMessage = null)
    {
        $this
            ->setDtoContractPartyInfo($dtoContractPartyInfo)
            ->setDtoPartnerInfo($dtoPartnerInfo)
            ->setResult($result)
            ->setResultMessage($resultMessage);
    }
    /**
     * Get dtoContractPartyInfo value
     * @return \StructType\DtoContractPartyInfo|null
     */
    public function getDtoContractPartyInfo()
    {
        return $this->dtoContractPartyInfo;
    }
    /**
     * Set dtoContractPartyInfo value
     * @param \StructType\DtoContractPartyInfo $dtoContractPartyInfo
     * @return \StructType\DtoPartnerInfoWrapper
     */
    public function setDtoContractPartyInfo(\StructType\DtoContractPartyInfo $dtoContractPartyInfo = null)
    {
        $this->dtoContractPartyInfo = $dtoContractPartyInfo;
        return $this;
    }
    /**
     * Get dtoPartnerInfo value
     * @return \StructType\DtoPartnerInfo|null
     */
    public function getDtoPartnerInfo()
    {
        return $this->dtoPartnerInfo;
    }
    /**
     * Set dtoPartnerInfo value
     * @param \StructType\DtoPartnerInfo $dtoPartnerInfo
     * @return \StructType\DtoPartnerInfoWrapper
     */
    public function setDtoPartnerInfo(\StructType\DtoPartnerInfo $dtoPartnerInfo = null)
    {
        $this->dtoPartnerInfo = $dtoPartnerInfo;
        return $this;
    }
    /**
     * Get result value
     * @return int|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param int $result
     * @return \StructType\DtoPartnerInfoWrapper
     */
    public function setResult($result = null)
    {
        // validation for constraint: int
        if (!is_null($result) && !(is_int($result) || ctype_digit($result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get resultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->resultMessage;
    }
    /**
     * Set resultMessage value
     * @param string $resultMessage
     * @return \StructType\DtoPartnerInfoWrapper
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->resultMessage = $resultMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoPartnerInfoWrapper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
