<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoClientInfo StructType
 * @subpackage Structs
 */
class DtoClientInfo extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $additionalInfo;
    /**
     * The appUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appUserId;
    /**
     * The appUsername
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appUsername;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sessionId;
    /**
     * The terminalId
     * @var int
     */
    public $terminalId;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for dtoClientInfo
     * @uses DtoClientInfo::setAdditionalInfo()
     * @uses DtoClientInfo::setAppUserId()
     * @uses DtoClientInfo::setAppUsername()
     * @uses DtoClientInfo::setSessionId()
     * @uses DtoClientInfo::setTerminalId()
     * @uses DtoClientInfo::setToken()
     * @param string $additionalInfo
     * @param string $appUserId
     * @param string $appUsername
     * @param string $sessionId
     * @param int $terminalId
     * @param string $token
     */
    public function __construct($additionalInfo = null, $appUserId = null, $appUsername = null, $sessionId = null, $terminalId = null, $token = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setAppUserId($appUserId)
            ->setAppUsername($appUsername)
            ->setSessionId($sessionId)
            ->setTerminalId($terminalId)
            ->setToken($token);
    }
    /**
     * Get additionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->additionalInfo;
    }
    /**
     * Set additionalInfo value
     * @param string $additionalInfo
     * @return \StructType\DtoClientInfo
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->additionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get appUserId value
     * @return string|null
     */
    public function getAppUserId()
    {
        return $this->appUserId;
    }
    /**
     * Set appUserId value
     * @param string $appUserId
     * @return \StructType\DtoClientInfo
     */
    public function setAppUserId($appUserId = null)
    {
        // validation for constraint: string
        if (!is_null($appUserId) && !is_string($appUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appUserId, true), gettype($appUserId)), __LINE__);
        }
        $this->appUserId = $appUserId;
        return $this;
    }
    /**
     * Get appUsername value
     * @return string|null
     */
    public function getAppUsername()
    {
        return $this->appUsername;
    }
    /**
     * Set appUsername value
     * @param string $appUsername
     * @return \StructType\DtoClientInfo
     */
    public function setAppUsername($appUsername = null)
    {
        // validation for constraint: string
        if (!is_null($appUsername) && !is_string($appUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appUsername, true), gettype($appUsername)), __LINE__);
        }
        $this->appUsername = $appUsername;
        return $this;
    }
    /**
     * Get sessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \StructType\DtoClientInfo
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get terminalId value
     * @return int|null
     */
    public function getTerminalId()
    {
        return $this->terminalId;
    }
    /**
     * Set terminalId value
     * @param int $terminalId
     * @return \StructType\DtoClientInfo
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: int
        if (!is_null($terminalId) && !(is_int($terminalId) || ctype_digit($terminalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        $this->terminalId = $terminalId;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\DtoClientInfo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoClientInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
