<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkSubscription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $trackingCode
     * @param string $referenceId
     * @param string $citizenSessionId
     * @param \StructType\DtoSubInfoWrapper $dtoSubInfoWrapper
     * @return \StructType\DtoCheckSubscriptionResult|bool
     */
    public function checkSubscription(\StructType\DtoClientInfo $dtoClientInfo, $trackingCode, $referenceId, $citizenSessionId, \StructType\DtoSubInfoWrapper $dtoSubInfoWrapper)
    {
        try {
            $this->setResult($this->getSoapClient()->checkSubscription($dtoClientInfo, $trackingCode, $referenceId, $citizenSessionId, $dtoSubInfoWrapper));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DtoCheckSubscriptionResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
