<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webapi.ihio.gov.ir/hdkcore/api/services/prescriptionservice?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webapi.ihio.gov.ir/hdkcore/api/services/prescriptionservice?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Fetch ServiceType
 */
$fetch = new \ServiceType\Fetch($options);
/**
 * Sample call for fetchDeliveredPrescriptionByTrackingCode operation/method
 */
if ($fetch->fetchDeliveredPrescriptionByTrackingCode(new \StructType\DtoClientInfo(), $trackingCode, $nationalNumber) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Sample call for fetchPartnerInfoByPrintCode operation/method
 */
if ($fetch->fetchPartnerInfoByPrintCode(new \StructType\DtoClientInfo(), $printCode) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Sample call for fetchPresriptionInfoByPrintCode operation/method
 */
if ($fetch->fetchPresriptionInfoByPrintCode(new \StructType\DtoClientInfo(), $printCode, $citizenSessionId) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Sample call for fetchPresriptionInfoBySamadCode operation/method
 */
if ($fetch->fetchPresriptionInfoBySamadCode(new \StructType\DtoClientInfo(), $samadCode, $citizenSessionId) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkSubscription operation/method
 */
if ($check->checkSubscription(new \StructType\DtoClientInfo(), $trackingCode, $referenceId, $citizenSessionId, new \StructType\DtoSubInfoWrapper()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
/**
 * Sample call for doSavePrescription operation/method
 */
if ($do->doSavePrescription(new \StructType\DtoClientInfo(), $samadCode, $citizenSessionId, new \StructType\DtoPrescription()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doDeliveredPrescription operation/method
 */
if ($do->doDeliveredPrescription(new \StructType\DtoClientInfo(), $printCode, $citizenSessionId, new \StructType\DtoDeliveredPrescription()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
