<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoSubscriptionDeliveredInfo StructType
 * @subpackage Structs
 */
class DtoSubscriptionDeliveredInfo extends AbstractStructBase
{
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The consumption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $consumption;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The numberOfDelivered
     * @var int
     */
    public $numberOfDelivered;
    /**
     * The patientPayment
     * @var float
     */
    public $patientPayment;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceFullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceFullName;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The serviceInterfaceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceInterfaceName;
    /**
     * The serviceNationalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceNationalNumber;
    /**
     * The serviceShortName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceShortName;
    /**
     * Constructor method for dtoSubscriptionDeliveredInfo
     * @uses DtoSubscriptionDeliveredInfo::setAmount()
     * @uses DtoSubscriptionDeliveredInfo::setConsumption()
     * @uses DtoSubscriptionDeliveredInfo::setDescription()
     * @uses DtoSubscriptionDeliveredInfo::setId()
     * @uses DtoSubscriptionDeliveredInfo::setNumberOfDelivered()
     * @uses DtoSubscriptionDeliveredInfo::setPatientPayment()
     * @uses DtoSubscriptionDeliveredInfo::setServiceDescription()
     * @uses DtoSubscriptionDeliveredInfo::setServiceFullName()
     * @uses DtoSubscriptionDeliveredInfo::setServiceId()
     * @uses DtoSubscriptionDeliveredInfo::setServiceInterfaceName()
     * @uses DtoSubscriptionDeliveredInfo::setServiceNationalNumber()
     * @uses DtoSubscriptionDeliveredInfo::setServiceShortName()
     * @param float $amount
     * @param string $consumption
     * @param string $description
     * @param int $id
     * @param int $numberOfDelivered
     * @param float $patientPayment
     * @param string $serviceDescription
     * @param string $serviceFullName
     * @param int $serviceId
     * @param string $serviceInterfaceName
     * @param string $serviceNationalNumber
     * @param string $serviceShortName
     */
    public function __construct($amount = null, $consumption = null, $description = null, $id = null, $numberOfDelivered = null, $patientPayment = null, $serviceDescription = null, $serviceFullName = null, $serviceId = null, $serviceInterfaceName = null, $serviceNationalNumber = null, $serviceShortName = null)
    {
        $this
            ->setAmount($amount)
            ->setConsumption($consumption)
            ->setDescription($description)
            ->setId($id)
            ->setNumberOfDelivered($numberOfDelivered)
            ->setPatientPayment($patientPayment)
            ->setServiceDescription($serviceDescription)
            ->setServiceFullName($serviceFullName)
            ->setServiceId($serviceId)
            ->setServiceInterfaceName($serviceInterfaceName)
            ->setServiceNationalNumber($serviceNationalNumber)
            ->setServiceShortName($serviceShortName);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get consumption value
     * @return string|null
     */
    public function getConsumption()
    {
        return $this->consumption;
    }
    /**
     * Set consumption value
     * @param string $consumption
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: string
        if (!is_null($consumption) && !is_string($consumption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->consumption = $consumption;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get numberOfDelivered value
     * @return int|null
     */
    public function getNumberOfDelivered()
    {
        return $this->numberOfDelivered;
    }
    /**
     * Set numberOfDelivered value
     * @param int $numberOfDelivered
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setNumberOfDelivered($numberOfDelivered = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDelivered) && !(is_int($numberOfDelivered) || ctype_digit($numberOfDelivered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDelivered, true), gettype($numberOfDelivered)), __LINE__);
        }
        $this->numberOfDelivered = $numberOfDelivered;
        return $this;
    }
    /**
     * Get patientPayment value
     * @return float|null
     */
    public function getPatientPayment()
    {
        return $this->patientPayment;
    }
    /**
     * Set patientPayment value
     * @param float $patientPayment
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setPatientPayment($patientPayment = null)
    {
        // validation for constraint: float
        if (!is_null($patientPayment) && !(is_float($patientPayment) || is_numeric($patientPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($patientPayment, true), gettype($patientPayment)), __LINE__);
        }
        $this->patientPayment = $patientPayment;
        return $this;
    }
    /**
     * Get serviceDescription value
     * @return string|null
     */
    public function getServiceDescription()
    {
        return $this->serviceDescription;
    }
    /**
     * Set serviceDescription value
     * @param string $serviceDescription
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDescription, true), gettype($serviceDescription)), __LINE__);
        }
        $this->serviceDescription = $serviceDescription;
        return $this;
    }
    /**
     * Get serviceFullName value
     * @return string|null
     */
    public function getServiceFullName()
    {
        return $this->serviceFullName;
    }
    /**
     * Set serviceFullName value
     * @param string $serviceFullName
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setServiceFullName($serviceFullName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceFullName) && !is_string($serviceFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceFullName, true), gettype($serviceFullName)), __LINE__);
        }
        $this->serviceFullName = $serviceFullName;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get serviceInterfaceName value
     * @return string|null
     */
    public function getServiceInterfaceName()
    {
        return $this->serviceInterfaceName;
    }
    /**
     * Set serviceInterfaceName value
     * @param string $serviceInterfaceName
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setServiceInterfaceName($serviceInterfaceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInterfaceName) && !is_string($serviceInterfaceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceInterfaceName, true), gettype($serviceInterfaceName)), __LINE__);
        }
        $this->serviceInterfaceName = $serviceInterfaceName;
        return $this;
    }
    /**
     * Get serviceNationalNumber value
     * @return string|null
     */
    public function getServiceNationalNumber()
    {
        return $this->serviceNationalNumber;
    }
    /**
     * Set serviceNationalNumber value
     * @param string $serviceNationalNumber
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setServiceNationalNumber($serviceNationalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serviceNationalNumber) && !is_string($serviceNationalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceNationalNumber, true), gettype($serviceNationalNumber)), __LINE__);
        }
        $this->serviceNationalNumber = $serviceNationalNumber;
        return $this;
    }
    /**
     * Get serviceShortName value
     * @return string|null
     */
    public function getServiceShortName()
    {
        return $this->serviceShortName;
    }
    /**
     * Set serviceShortName value
     * @param string $serviceShortName
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public function setServiceShortName($serviceShortName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceShortName) && !is_string($serviceShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceShortName, true), gettype($serviceShortName)), __LINE__);
        }
        $this->serviceShortName = $serviceShortName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoSubscriptionDeliveredInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
