<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoSubInfoWrapper StructType
 * @subpackage Structs
 */
class DtoSubInfoWrapper extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $additionalInfo;
    /**
     * The dtoServiceCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DtoSubInfo
     */
    public $dtoServiceCount;
    /**
     * The otherServices
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoSubInfo[]
     */
    public $otherServices;
    /**
     * Constructor method for dtoSubInfoWrapper
     * @uses DtoSubInfoWrapper::setAdditionalInfo()
     * @uses DtoSubInfoWrapper::setDtoServiceCount()
     * @uses DtoSubInfoWrapper::setOtherServices()
     * @param string $additionalInfo
     * @param \StructType\DtoSubInfo $dtoServiceCount
     * @param \StructType\DtoSubInfo[] $otherServices
     */
    public function __construct($additionalInfo = null, \StructType\DtoSubInfo $dtoServiceCount = null, array $otherServices = array())
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setDtoServiceCount($dtoServiceCount)
            ->setOtherServices($otherServices);
    }
    /**
     * Get additionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->additionalInfo;
    }
    /**
     * Set additionalInfo value
     * @param string $additionalInfo
     * @return \StructType\DtoSubInfoWrapper
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->additionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get dtoServiceCount value
     * @return \StructType\DtoSubInfo|null
     */
    public function getDtoServiceCount()
    {
        return $this->dtoServiceCount;
    }
    /**
     * Set dtoServiceCount value
     * @param \StructType\DtoSubInfo $dtoServiceCount
     * @return \StructType\DtoSubInfoWrapper
     */
    public function setDtoServiceCount(\StructType\DtoSubInfo $dtoServiceCount = null)
    {
        $this->dtoServiceCount = $dtoServiceCount;
        return $this;
    }
    /**
     * Get otherServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoSubInfo[]|null
     */
    public function getOtherServices()
    {
        return isset($this->otherServices) ? $this->otherServices : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherServices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherServicesForArrayConstraintsFromSetOtherServices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoSubInfoWrapperOtherServicesItem) {
            // validation for constraint: itemType
            if (!$dtoSubInfoWrapperOtherServicesItem instanceof \StructType\DtoSubInfo) {
                $invalidValues[] = is_object($dtoSubInfoWrapperOtherServicesItem) ? get_class($dtoSubInfoWrapperOtherServicesItem) : sprintf('%s(%s)', gettype($dtoSubInfoWrapperOtherServicesItem), var_export($dtoSubInfoWrapperOtherServicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The otherServices property can only contain items of type \StructType\DtoSubInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set otherServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubInfo[] $otherServices
     * @return \StructType\DtoSubInfoWrapper
     */
    public function setOtherServices(array $otherServices = array())
    {
        // validation for constraint: array
        if ('' !== ($otherServicesArrayErrorMessage = self::validateOtherServicesForArrayConstraintsFromSetOtherServices($otherServices))) {
            throw new \InvalidArgumentException($otherServicesArrayErrorMessage, __LINE__);
        }
        if (is_null($otherServices) || (is_array($otherServices) && empty($otherServices))) {
            unset($this->otherServices);
        } else {
            $this->otherServices = $otherServices;
        }
        return $this;
    }
    /**
     * Add item to otherServices value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubInfo $item
     * @return \StructType\DtoSubInfoWrapper
     */
    public function addToOtherServices(\StructType\DtoSubInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoSubInfo) {
            throw new \InvalidArgumentException(sprintf('The otherServices property can only contain items of type \StructType\DtoSubInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->otherServices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoSubInfoWrapper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
