<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoPrescriptionInfo StructType
 * @subpackage Structs
 */
class DtoPrescriptionInfo extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $additionalInfo;
    /**
     * The contractPartyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractPartyName;
    /**
     * The creationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creationDate;
    /**
     * The dtoSubscriptionInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoSubscriptionInfo[]
     */
    public $dtoSubscriptionInfos;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The partnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partnerName;
    /**
     * The partnerPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partnerPhone;
    /**
     * The samadCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $samadCode;
    /**
     * The typeId
     * @var int
     */
    public $typeId;
    /**
     * Constructor method for dtoPrescriptionInfo
     * @uses DtoPrescriptionInfo::setAdditionalInfo()
     * @uses DtoPrescriptionInfo::setContractPartyName()
     * @uses DtoPrescriptionInfo::setCreationDate()
     * @uses DtoPrescriptionInfo::setDtoSubscriptionInfos()
     * @uses DtoPrescriptionInfo::setId()
     * @uses DtoPrescriptionInfo::setPartnerName()
     * @uses DtoPrescriptionInfo::setPartnerPhone()
     * @uses DtoPrescriptionInfo::setSamadCode()
     * @uses DtoPrescriptionInfo::setTypeId()
     * @param string[] $additionalInfo
     * @param string $contractPartyName
     * @param string $creationDate
     * @param \StructType\DtoSubscriptionInfo[] $dtoSubscriptionInfos
     * @param int $id
     * @param string $partnerName
     * @param string $partnerPhone
     * @param string $samadCode
     * @param int $typeId
     */
    public function __construct(array $additionalInfo = array(), $contractPartyName = null, $creationDate = null, array $dtoSubscriptionInfos = array(), $id = null, $partnerName = null, $partnerPhone = null, $samadCode = null, $typeId = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setContractPartyName($contractPartyName)
            ->setCreationDate($creationDate)
            ->setDtoSubscriptionInfos($dtoSubscriptionInfos)
            ->setId($id)
            ->setPartnerName($partnerName)
            ->setPartnerPhone($partnerPhone)
            ->setSamadCode($samadCode)
            ->setTypeId($typeId);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoPrescriptionInfoAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!is_string($dtoPrescriptionInfoAdditionalInfoItem)) {
                $invalidValues[] = is_object($dtoPrescriptionInfoAdditionalInfoItem) ? get_class($dtoPrescriptionInfoAdditionalInfoItem) : sprintf('%s(%s)', gettype($dtoPrescriptionInfoAdditionalInfoItem), var_export($dtoPrescriptionInfoAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $additionalInfo
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to additionalInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoPrescriptionInfo
     */
    public function addToAdditionalInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInfo[] = $item;
        return $this;
    }
    /**
     * Get contractPartyName value
     * @return string|null
     */
    public function getContractPartyName()
    {
        return $this->contractPartyName;
    }
    /**
     * Set contractPartyName value
     * @param string $contractPartyName
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setContractPartyName($contractPartyName = null)
    {
        // validation for constraint: string
        if (!is_null($contractPartyName) && !is_string($contractPartyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractPartyName, true), gettype($contractPartyName)), __LINE__);
        }
        $this->contractPartyName = $contractPartyName;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get dtoSubscriptionInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoSubscriptionInfo[]|null
     */
    public function getDtoSubscriptionInfos()
    {
        return isset($this->dtoSubscriptionInfos) ? $this->dtoSubscriptionInfos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDtoSubscriptionInfos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtoSubscriptionInfos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtoSubscriptionInfosForArrayConstraintsFromSetDtoSubscriptionInfos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoPrescriptionInfoDtoSubscriptionInfosItem) {
            // validation for constraint: itemType
            if (!$dtoPrescriptionInfoDtoSubscriptionInfosItem instanceof \StructType\DtoSubscriptionInfo) {
                $invalidValues[] = is_object($dtoPrescriptionInfoDtoSubscriptionInfosItem) ? get_class($dtoPrescriptionInfoDtoSubscriptionInfosItem) : sprintf('%s(%s)', gettype($dtoPrescriptionInfoDtoSubscriptionInfosItem), var_export($dtoPrescriptionInfoDtoSubscriptionInfosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtoSubscriptionInfos property can only contain items of type \StructType\DtoSubscriptionInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtoSubscriptionInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionInfo[] $dtoSubscriptionInfos
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setDtoSubscriptionInfos(array $dtoSubscriptionInfos = array())
    {
        // validation for constraint: array
        if ('' !== ($dtoSubscriptionInfosArrayErrorMessage = self::validateDtoSubscriptionInfosForArrayConstraintsFromSetDtoSubscriptionInfos($dtoSubscriptionInfos))) {
            throw new \InvalidArgumentException($dtoSubscriptionInfosArrayErrorMessage, __LINE__);
        }
        if (is_null($dtoSubscriptionInfos) || (is_array($dtoSubscriptionInfos) && empty($dtoSubscriptionInfos))) {
            unset($this->dtoSubscriptionInfos);
        } else {
            $this->dtoSubscriptionInfos = $dtoSubscriptionInfos;
        }
        return $this;
    }
    /**
     * Add item to dtoSubscriptionInfos value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionInfo $item
     * @return \StructType\DtoPrescriptionInfo
     */
    public function addToDtoSubscriptionInfos(\StructType\DtoSubscriptionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoSubscriptionInfo) {
            throw new \InvalidArgumentException(sprintf('The dtoSubscriptionInfos property can only contain items of type \StructType\DtoSubscriptionInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtoSubscriptionInfos[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get partnerName value
     * @return string|null
     */
    public function getPartnerName()
    {
        return $this->partnerName;
    }
    /**
     * Set partnerName value
     * @param string $partnerName
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setPartnerName($partnerName = null)
    {
        // validation for constraint: string
        if (!is_null($partnerName) && !is_string($partnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerName, true), gettype($partnerName)), __LINE__);
        }
        $this->partnerName = $partnerName;
        return $this;
    }
    /**
     * Get partnerPhone value
     * @return string|null
     */
    public function getPartnerPhone()
    {
        return $this->partnerPhone;
    }
    /**
     * Set partnerPhone value
     * @param string $partnerPhone
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setPartnerPhone($partnerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($partnerPhone) && !is_string($partnerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerPhone, true), gettype($partnerPhone)), __LINE__);
        }
        $this->partnerPhone = $partnerPhone;
        return $this;
    }
    /**
     * Get samadCode value
     * @return string|null
     */
    public function getSamadCode()
    {
        return $this->samadCode;
    }
    /**
     * Set samadCode value
     * @param string $samadCode
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setSamadCode($samadCode = null)
    {
        // validation for constraint: string
        if (!is_null($samadCode) && !is_string($samadCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($samadCode, true), gettype($samadCode)), __LINE__);
        }
        $this->samadCode = $samadCode;
        return $this;
    }
    /**
     * Get typeId value
     * @return int|null
     */
    public function getTypeId()
    {
        return $this->typeId;
    }
    /**
     * Set typeId value
     * @param int $typeId
     * @return \StructType\DtoPrescriptionInfo
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: int
        if (!is_null($typeId) && !(is_int($typeId) || ctype_digit($typeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoPrescriptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
