<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoDeliveredPrescriptionInfo StructType
 * @subpackage Structs
 */
class DtoDeliveredPrescriptionInfo extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $additionalInfo;
    /**
     * The contractPartyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractPartyName;
    /**
     * The deliveredDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveredDate;
    /**
     * The dtoSubscriptionDeliveredInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoSubscriptionDeliveredInfo[]
     */
    public $dtoSubscriptionDeliveredInfos;
    /**
     * The dtoSubscriptionDeliveredInfosWithNoReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoSubscriptionDeliveredInfo[]
     */
    public $dtoSubscriptionDeliveredInfosWithNoReference;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The partnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partnerName;
    /**
     * The partnerPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partnerPhone;
    /**
     * The samadCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $samadCode;
    /**
     * The totalAmount
     * @var float
     */
    public $totalAmount;
    /**
     * The totalPatientPayment
     * @var float
     */
    public $totalPatientPayment;
    /**
     * The typeId
     * @var int
     */
    public $typeId;
    /**
     * Constructor method for dtoDeliveredPrescriptionInfo
     * @uses DtoDeliveredPrescriptionInfo::setAdditionalInfo()
     * @uses DtoDeliveredPrescriptionInfo::setContractPartyName()
     * @uses DtoDeliveredPrescriptionInfo::setDeliveredDate()
     * @uses DtoDeliveredPrescriptionInfo::setDtoSubscriptionDeliveredInfos()
     * @uses DtoDeliveredPrescriptionInfo::setDtoSubscriptionDeliveredInfosWithNoReference()
     * @uses DtoDeliveredPrescriptionInfo::setId()
     * @uses DtoDeliveredPrescriptionInfo::setPartnerName()
     * @uses DtoDeliveredPrescriptionInfo::setPartnerPhone()
     * @uses DtoDeliveredPrescriptionInfo::setSamadCode()
     * @uses DtoDeliveredPrescriptionInfo::setTotalAmount()
     * @uses DtoDeliveredPrescriptionInfo::setTotalPatientPayment()
     * @uses DtoDeliveredPrescriptionInfo::setTypeId()
     * @param string[] $additionalInfo
     * @param string $contractPartyName
     * @param string $deliveredDate
     * @param \StructType\DtoSubscriptionDeliveredInfo[] $dtoSubscriptionDeliveredInfos
     * @param \StructType\DtoSubscriptionDeliveredInfo[] $dtoSubscriptionDeliveredInfosWithNoReference
     * @param int $id
     * @param string $partnerName
     * @param string $partnerPhone
     * @param string $samadCode
     * @param float $totalAmount
     * @param float $totalPatientPayment
     * @param int $typeId
     */
    public function __construct(array $additionalInfo = array(), $contractPartyName = null, $deliveredDate = null, array $dtoSubscriptionDeliveredInfos = array(), array $dtoSubscriptionDeliveredInfosWithNoReference = array(), $id = null, $partnerName = null, $partnerPhone = null, $samadCode = null, $totalAmount = null, $totalPatientPayment = null, $typeId = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setContractPartyName($contractPartyName)
            ->setDeliveredDate($deliveredDate)
            ->setDtoSubscriptionDeliveredInfos($dtoSubscriptionDeliveredInfos)
            ->setDtoSubscriptionDeliveredInfosWithNoReference($dtoSubscriptionDeliveredInfosWithNoReference)
            ->setId($id)
            ->setPartnerName($partnerName)
            ->setPartnerPhone($partnerPhone)
            ->setSamadCode($samadCode)
            ->setTotalAmount($totalAmount)
            ->setTotalPatientPayment($totalPatientPayment)
            ->setTypeId($typeId);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoDeliveredPrescriptionInfoAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!is_string($dtoDeliveredPrescriptionInfoAdditionalInfoItem)) {
                $invalidValues[] = is_object($dtoDeliveredPrescriptionInfoAdditionalInfoItem) ? get_class($dtoDeliveredPrescriptionInfoAdditionalInfoItem) : sprintf('%s(%s)', gettype($dtoDeliveredPrescriptionInfoAdditionalInfoItem), var_export($dtoDeliveredPrescriptionInfoAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $additionalInfo
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to additionalInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function addToAdditionalInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInfo[] = $item;
        return $this;
    }
    /**
     * Get contractPartyName value
     * @return string|null
     */
    public function getContractPartyName()
    {
        return $this->contractPartyName;
    }
    /**
     * Set contractPartyName value
     * @param string $contractPartyName
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setContractPartyName($contractPartyName = null)
    {
        // validation for constraint: string
        if (!is_null($contractPartyName) && !is_string($contractPartyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractPartyName, true), gettype($contractPartyName)), __LINE__);
        }
        $this->contractPartyName = $contractPartyName;
        return $this;
    }
    /**
     * Get deliveredDate value
     * @return string|null
     */
    public function getDeliveredDate()
    {
        return $this->deliveredDate;
    }
    /**
     * Set deliveredDate value
     * @param string $deliveredDate
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setDeliveredDate($deliveredDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredDate) && !is_string($deliveredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveredDate, true), gettype($deliveredDate)), __LINE__);
        }
        $this->deliveredDate = $deliveredDate;
        return $this;
    }
    /**
     * Get dtoSubscriptionDeliveredInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoSubscriptionDeliveredInfo[]|null
     */
    public function getDtoSubscriptionDeliveredInfos()
    {
        return isset($this->dtoSubscriptionDeliveredInfos) ? $this->dtoSubscriptionDeliveredInfos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDtoSubscriptionDeliveredInfos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtoSubscriptionDeliveredInfos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtoSubscriptionDeliveredInfosForArrayConstraintsFromSetDtoSubscriptionDeliveredInfos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosItem) {
            // validation for constraint: itemType
            if (!$dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosItem instanceof \StructType\DtoSubscriptionDeliveredInfo) {
                $invalidValues[] = is_object($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosItem) ? get_class($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosItem) : sprintf('%s(%s)', gettype($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosItem), var_export($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtoSubscriptionDeliveredInfos property can only contain items of type \StructType\DtoSubscriptionDeliveredInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtoSubscriptionDeliveredInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionDeliveredInfo[] $dtoSubscriptionDeliveredInfos
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setDtoSubscriptionDeliveredInfos(array $dtoSubscriptionDeliveredInfos = array())
    {
        // validation for constraint: array
        if ('' !== ($dtoSubscriptionDeliveredInfosArrayErrorMessage = self::validateDtoSubscriptionDeliveredInfosForArrayConstraintsFromSetDtoSubscriptionDeliveredInfos($dtoSubscriptionDeliveredInfos))) {
            throw new \InvalidArgumentException($dtoSubscriptionDeliveredInfosArrayErrorMessage, __LINE__);
        }
        if (is_null($dtoSubscriptionDeliveredInfos) || (is_array($dtoSubscriptionDeliveredInfos) && empty($dtoSubscriptionDeliveredInfos))) {
            unset($this->dtoSubscriptionDeliveredInfos);
        } else {
            $this->dtoSubscriptionDeliveredInfos = $dtoSubscriptionDeliveredInfos;
        }
        return $this;
    }
    /**
     * Add item to dtoSubscriptionDeliveredInfos value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionDeliveredInfo $item
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function addToDtoSubscriptionDeliveredInfos(\StructType\DtoSubscriptionDeliveredInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoSubscriptionDeliveredInfo) {
            throw new \InvalidArgumentException(sprintf('The dtoSubscriptionDeliveredInfos property can only contain items of type \StructType\DtoSubscriptionDeliveredInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtoSubscriptionDeliveredInfos[] = $item;
        return $this;
    }
    /**
     * Get dtoSubscriptionDeliveredInfosWithNoReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoSubscriptionDeliveredInfo[]|null
     */
    public function getDtoSubscriptionDeliveredInfosWithNoReference()
    {
        return isset($this->dtoSubscriptionDeliveredInfosWithNoReference) ? $this->dtoSubscriptionDeliveredInfosWithNoReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDtoSubscriptionDeliveredInfosWithNoReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtoSubscriptionDeliveredInfosWithNoReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtoSubscriptionDeliveredInfosWithNoReferenceForArrayConstraintsFromSetDtoSubscriptionDeliveredInfosWithNoReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosWithNoReferenceItem) {
            // validation for constraint: itemType
            if (!$dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosWithNoReferenceItem instanceof \StructType\DtoSubscriptionDeliveredInfo) {
                $invalidValues[] = is_object($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosWithNoReferenceItem) ? get_class($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosWithNoReferenceItem) : sprintf('%s(%s)', gettype($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosWithNoReferenceItem), var_export($dtoDeliveredPrescriptionInfoDtoSubscriptionDeliveredInfosWithNoReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtoSubscriptionDeliveredInfosWithNoReference property can only contain items of type \StructType\DtoSubscriptionDeliveredInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtoSubscriptionDeliveredInfosWithNoReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionDeliveredInfo[] $dtoSubscriptionDeliveredInfosWithNoReference
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setDtoSubscriptionDeliveredInfosWithNoReference(array $dtoSubscriptionDeliveredInfosWithNoReference = array())
    {
        // validation for constraint: array
        if ('' !== ($dtoSubscriptionDeliveredInfosWithNoReferenceArrayErrorMessage = self::validateDtoSubscriptionDeliveredInfosWithNoReferenceForArrayConstraintsFromSetDtoSubscriptionDeliveredInfosWithNoReference($dtoSubscriptionDeliveredInfosWithNoReference))) {
            throw new \InvalidArgumentException($dtoSubscriptionDeliveredInfosWithNoReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($dtoSubscriptionDeliveredInfosWithNoReference) || (is_array($dtoSubscriptionDeliveredInfosWithNoReference) && empty($dtoSubscriptionDeliveredInfosWithNoReference))) {
            unset($this->dtoSubscriptionDeliveredInfosWithNoReference);
        } else {
            $this->dtoSubscriptionDeliveredInfosWithNoReference = $dtoSubscriptionDeliveredInfosWithNoReference;
        }
        return $this;
    }
    /**
     * Add item to dtoSubscriptionDeliveredInfosWithNoReference value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscriptionDeliveredInfo $item
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function addToDtoSubscriptionDeliveredInfosWithNoReference(\StructType\DtoSubscriptionDeliveredInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoSubscriptionDeliveredInfo) {
            throw new \InvalidArgumentException(sprintf('The dtoSubscriptionDeliveredInfosWithNoReference property can only contain items of type \StructType\DtoSubscriptionDeliveredInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtoSubscriptionDeliveredInfosWithNoReference[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get partnerName value
     * @return string|null
     */
    public function getPartnerName()
    {
        return $this->partnerName;
    }
    /**
     * Set partnerName value
     * @param string $partnerName
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setPartnerName($partnerName = null)
    {
        // validation for constraint: string
        if (!is_null($partnerName) && !is_string($partnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerName, true), gettype($partnerName)), __LINE__);
        }
        $this->partnerName = $partnerName;
        return $this;
    }
    /**
     * Get partnerPhone value
     * @return string|null
     */
    public function getPartnerPhone()
    {
        return $this->partnerPhone;
    }
    /**
     * Set partnerPhone value
     * @param string $partnerPhone
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setPartnerPhone($partnerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($partnerPhone) && !is_string($partnerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerPhone, true), gettype($partnerPhone)), __LINE__);
        }
        $this->partnerPhone = $partnerPhone;
        return $this;
    }
    /**
     * Get samadCode value
     * @return string|null
     */
    public function getSamadCode()
    {
        return $this->samadCode;
    }
    /**
     * Set samadCode value
     * @param string $samadCode
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setSamadCode($samadCode = null)
    {
        // validation for constraint: string
        if (!is_null($samadCode) && !is_string($samadCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($samadCode, true), gettype($samadCode)), __LINE__);
        }
        $this->samadCode = $samadCode;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get totalPatientPayment value
     * @return float|null
     */
    public function getTotalPatientPayment()
    {
        return $this->totalPatientPayment;
    }
    /**
     * Set totalPatientPayment value
     * @param float $totalPatientPayment
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setTotalPatientPayment($totalPatientPayment = null)
    {
        // validation for constraint: float
        if (!is_null($totalPatientPayment) && !(is_float($totalPatientPayment) || is_numeric($totalPatientPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPatientPayment, true), gettype($totalPatientPayment)), __LINE__);
        }
        $this->totalPatientPayment = $totalPatientPayment;
        return $this;
    }
    /**
     * Get typeId value
     * @return int|null
     */
    public function getTypeId()
    {
        return $this->typeId;
    }
    /**
     * Set typeId value
     * @param int $typeId
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: int
        if (!is_null($typeId) && !(is_int($typeId) || ctype_digit($typeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoDeliveredPrescriptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
