<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoDeliveredPrescription StructType
 * @subpackage Structs
 */
class DtoDeliveredPrescription extends AbstractStructBase
{
    /**
     * The dtoDeliveredSubscriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoDeliveredSubscription[]
     */
    public $dtoDeliveredSubscriptions;
    /**
     * The prescriptionId
     * @var int
     */
    public $prescriptionId;
    /**
     * The totalAmount
     * @var float
     */
    public $totalAmount;
    /**
     * The totalPaitentPayment
     * @var float
     */
    public $totalPaitentPayment;
    /**
     * Constructor method for dtoDeliveredPrescription
     * @uses DtoDeliveredPrescription::setDtoDeliveredSubscriptions()
     * @uses DtoDeliveredPrescription::setPrescriptionId()
     * @uses DtoDeliveredPrescription::setTotalAmount()
     * @uses DtoDeliveredPrescription::setTotalPaitentPayment()
     * @param \StructType\DtoDeliveredSubscription[] $dtoDeliveredSubscriptions
     * @param int $prescriptionId
     * @param float $totalAmount
     * @param float $totalPaitentPayment
     */
    public function __construct(array $dtoDeliveredSubscriptions = array(), $prescriptionId = null, $totalAmount = null, $totalPaitentPayment = null)
    {
        $this
            ->setDtoDeliveredSubscriptions($dtoDeliveredSubscriptions)
            ->setPrescriptionId($prescriptionId)
            ->setTotalAmount($totalAmount)
            ->setTotalPaitentPayment($totalPaitentPayment);
    }
    /**
     * Get dtoDeliveredSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoDeliveredSubscription[]|null
     */
    public function getDtoDeliveredSubscriptions()
    {
        return isset($this->dtoDeliveredSubscriptions) ? $this->dtoDeliveredSubscriptions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDtoDeliveredSubscriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtoDeliveredSubscriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtoDeliveredSubscriptionsForArrayConstraintsFromSetDtoDeliveredSubscriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoDeliveredPrescriptionDtoDeliveredSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$dtoDeliveredPrescriptionDtoDeliveredSubscriptionsItem instanceof \StructType\DtoDeliveredSubscription) {
                $invalidValues[] = is_object($dtoDeliveredPrescriptionDtoDeliveredSubscriptionsItem) ? get_class($dtoDeliveredPrescriptionDtoDeliveredSubscriptionsItem) : sprintf('%s(%s)', gettype($dtoDeliveredPrescriptionDtoDeliveredSubscriptionsItem), var_export($dtoDeliveredPrescriptionDtoDeliveredSubscriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtoDeliveredSubscriptions property can only contain items of type \StructType\DtoDeliveredSubscription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtoDeliveredSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoDeliveredSubscription[] $dtoDeliveredSubscriptions
     * @return \StructType\DtoDeliveredPrescription
     */
    public function setDtoDeliveredSubscriptions(array $dtoDeliveredSubscriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($dtoDeliveredSubscriptionsArrayErrorMessage = self::validateDtoDeliveredSubscriptionsForArrayConstraintsFromSetDtoDeliveredSubscriptions($dtoDeliveredSubscriptions))) {
            throw new \InvalidArgumentException($dtoDeliveredSubscriptionsArrayErrorMessage, __LINE__);
        }
        if (is_null($dtoDeliveredSubscriptions) || (is_array($dtoDeliveredSubscriptions) && empty($dtoDeliveredSubscriptions))) {
            unset($this->dtoDeliveredSubscriptions);
        } else {
            $this->dtoDeliveredSubscriptions = $dtoDeliveredSubscriptions;
        }
        return $this;
    }
    /**
     * Add item to dtoDeliveredSubscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoDeliveredSubscription $item
     * @return \StructType\DtoDeliveredPrescription
     */
    public function addToDtoDeliveredSubscriptions(\StructType\DtoDeliveredSubscription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoDeliveredSubscription) {
            throw new \InvalidArgumentException(sprintf('The dtoDeliveredSubscriptions property can only contain items of type \StructType\DtoDeliveredSubscription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtoDeliveredSubscriptions[] = $item;
        return $this;
    }
    /**
     * Get prescriptionId value
     * @return int|null
     */
    public function getPrescriptionId()
    {
        return $this->prescriptionId;
    }
    /**
     * Set prescriptionId value
     * @param int $prescriptionId
     * @return \StructType\DtoDeliveredPrescription
     */
    public function setPrescriptionId($prescriptionId = null)
    {
        // validation for constraint: int
        if (!is_null($prescriptionId) && !(is_int($prescriptionId) || ctype_digit($prescriptionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prescriptionId, true), gettype($prescriptionId)), __LINE__);
        }
        $this->prescriptionId = $prescriptionId;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\DtoDeliveredPrescription
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get totalPaitentPayment value
     * @return float|null
     */
    public function getTotalPaitentPayment()
    {
        return $this->totalPaitentPayment;
    }
    /**
     * Set totalPaitentPayment value
     * @param float $totalPaitentPayment
     * @return \StructType\DtoDeliveredPrescription
     */
    public function setTotalPaitentPayment($totalPaitentPayment = null)
    {
        // validation for constraint: float
        if (!is_null($totalPaitentPayment) && !(is_float($totalPaitentPayment) || is_numeric($totalPaitentPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPaitentPayment, true), gettype($totalPaitentPayment)), __LINE__);
        }
        $this->totalPaitentPayment = $totalPaitentPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoDeliveredPrescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
