<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoContractPartyInfo StructType
 * @subpackage Structs
 */
class DtoContractPartyInfo extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $additionalInfo;
    /**
     * The cellPhoneNo
     * @var int
     */
    public $cellPhoneNo;
    /**
     * The gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The nationalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nationalNumber;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for dtoContractPartyInfo
     * @uses DtoContractPartyInfo::setAdditionalInfo()
     * @uses DtoContractPartyInfo::setCellPhoneNo()
     * @uses DtoContractPartyInfo::setGender()
     * @uses DtoContractPartyInfo::setId()
     * @uses DtoContractPartyInfo::setLastName()
     * @uses DtoContractPartyInfo::setName()
     * @uses DtoContractPartyInfo::setNationalNumber()
     * @uses DtoContractPartyInfo::setType()
     * @param string[] $additionalInfo
     * @param int $cellPhoneNo
     * @param string $gender
     * @param int $id
     * @param string $lastName
     * @param string $name
     * @param string $nationalNumber
     * @param string $type
     */
    public function __construct(array $additionalInfo = array(), $cellPhoneNo = null, $gender = null, $id = null, $lastName = null, $name = null, $nationalNumber = null, $type = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setCellPhoneNo($cellPhoneNo)
            ->setGender($gender)
            ->setId($id)
            ->setLastName($lastName)
            ->setName($name)
            ->setNationalNumber($nationalNumber)
            ->setType($type);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoContractPartyInfoAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!is_string($dtoContractPartyInfoAdditionalInfoItem)) {
                $invalidValues[] = is_object($dtoContractPartyInfoAdditionalInfoItem) ? get_class($dtoContractPartyInfoAdditionalInfoItem) : sprintf('%s(%s)', gettype($dtoContractPartyInfoAdditionalInfoItem), var_export($dtoContractPartyInfoAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $additionalInfo
     * @return \StructType\DtoContractPartyInfo
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to additionalInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoContractPartyInfo
     */
    public function addToAdditionalInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInfo[] = $item;
        return $this;
    }
    /**
     * Get cellPhoneNo value
     * @return int|null
     */
    public function getCellPhoneNo()
    {
        return $this->cellPhoneNo;
    }
    /**
     * Set cellPhoneNo value
     * @param int $cellPhoneNo
     * @return \StructType\DtoContractPartyInfo
     */
    public function setCellPhoneNo($cellPhoneNo = null)
    {
        // validation for constraint: int
        if (!is_null($cellPhoneNo) && !(is_int($cellPhoneNo) || ctype_digit($cellPhoneNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cellPhoneNo, true), gettype($cellPhoneNo)), __LINE__);
        }
        $this->cellPhoneNo = $cellPhoneNo;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @param string $gender
     * @return \StructType\DtoContractPartyInfo
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DtoContractPartyInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\DtoContractPartyInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DtoContractPartyInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get nationalNumber value
     * @return string|null
     */
    public function getNationalNumber()
    {
        return $this->nationalNumber;
    }
    /**
     * Set nationalNumber value
     * @param string $nationalNumber
     * @return \StructType\DtoContractPartyInfo
     */
    public function setNationalNumber($nationalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nationalNumber) && !is_string($nationalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalNumber, true), gettype($nationalNumber)), __LINE__);
        }
        $this->nationalNumber = $nationalNumber;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\DtoContractPartyInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoContractPartyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
