<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Do ServiceType
 * @subpackage Services
 */
class _Do extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named doSavePrescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $samadCode
     * @param string $citizenSessionId
     * @param \StructType\DtoPrescription $dtoPrescription
     * @return \StructType\DtoPrintCodeWrapper|bool
     */
    public function doSavePrescription(\StructType\DtoClientInfo $dtoClientInfo, $samadCode, $citizenSessionId, \StructType\DtoPrescription $dtoPrescription)
    {
        try {
            $this->setResult($this->getSoapClient()->doSavePrescription($dtoClientInfo, $samadCode, $citizenSessionId, $dtoPrescription));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named doDeliveredPrescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $printCode
     * @param string $citizenSessionId
     * @param \StructType\DtoDeliveredPrescription $dtoDeliveredPrescription
     * @return void|bool
     */
    public function doDeliveredPrescription(\StructType\DtoClientInfo $dtoClientInfo, $printCode, $citizenSessionId, \StructType\DtoDeliveredPrescription $dtoDeliveredPrescription)
    {
        try {
            $this->setResult($this->getSoapClient()->doDeliveredPrescription($dtoClientInfo, $printCode, $citizenSessionId, $dtoDeliveredPrescription));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void|\StructType\DtoPrintCodeWrapper
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
