<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoSubscription StructType
 * @subpackage Structs
 */
class DtoSubscription extends AbstractStructBase
{
    /**
     * The checkCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkCode;
    /**
     * The consumption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $consumption;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The numberOfRequest
     * @var int
     */
    public $numberOfRequest;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The subscriptionId
     * @var int
     */
    public $subscriptionId;
    /**
     * Constructor method for dtoSubscription
     * @uses DtoSubscription::setCheckCode()
     * @uses DtoSubscription::setConsumption()
     * @uses DtoSubscription::setDescription()
     * @uses DtoSubscription::setNumberOfRequest()
     * @uses DtoSubscription::setServiceId()
     * @uses DtoSubscription::setSubscriptionId()
     * @param string $checkCode
     * @param string $consumption
     * @param string $description
     * @param int $numberOfRequest
     * @param int $serviceId
     * @param int $subscriptionId
     */
    public function __construct($checkCode = null, $consumption = null, $description = null, $numberOfRequest = null, $serviceId = null, $subscriptionId = null)
    {
        $this
            ->setCheckCode($checkCode)
            ->setConsumption($consumption)
            ->setDescription($description)
            ->setNumberOfRequest($numberOfRequest)
            ->setServiceId($serviceId)
            ->setSubscriptionId($subscriptionId);
    }
    /**
     * Get checkCode value
     * @return string|null
     */
    public function getCheckCode()
    {
        return $this->checkCode;
    }
    /**
     * Set checkCode value
     * @param string $checkCode
     * @return \StructType\DtoSubscription
     */
    public function setCheckCode($checkCode = null)
    {
        // validation for constraint: string
        if (!is_null($checkCode) && !is_string($checkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkCode, true), gettype($checkCode)), __LINE__);
        }
        $this->checkCode = $checkCode;
        return $this;
    }
    /**
     * Get consumption value
     * @return string|null
     */
    public function getConsumption()
    {
        return $this->consumption;
    }
    /**
     * Set consumption value
     * @param string $consumption
     * @return \StructType\DtoSubscription
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: string
        if (!is_null($consumption) && !is_string($consumption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->consumption = $consumption;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DtoSubscription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberOfRequest value
     * @return int|null
     */
    public function getNumberOfRequest()
    {
        return $this->numberOfRequest;
    }
    /**
     * Set numberOfRequest value
     * @param int $numberOfRequest
     * @return \StructType\DtoSubscription
     */
    public function setNumberOfRequest($numberOfRequest = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRequest) && !(is_int($numberOfRequest) || ctype_digit($numberOfRequest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfRequest, true), gettype($numberOfRequest)), __LINE__);
        }
        $this->numberOfRequest = $numberOfRequest;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\DtoSubscription
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get subscriptionId value
     * @return int|null
     */
    public function getSubscriptionId()
    {
        return $this->subscriptionId;
    }
    /**
     * Set subscriptionId value
     * @param int $subscriptionId
     * @return \StructType\DtoSubscription
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionId) && !(is_int($subscriptionId) || ctype_digit($subscriptionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        $this->subscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
