<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoSubInfo StructType
 * @subpackage Structs
 */
class DtoSubInfo extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $additionalInfo;
    /**
     * The count
     * @var float
     */
    public $count;
    /**
     * The nationalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nationalNumber;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * Constructor method for dtoSubInfo
     * @uses DtoSubInfo::setAdditionalInfo()
     * @uses DtoSubInfo::setCount()
     * @uses DtoSubInfo::setNationalNumber()
     * @uses DtoSubInfo::setType()
     * @uses DtoSubInfo::setUnit()
     * @param string $additionalInfo
     * @param float $count
     * @param string $nationalNumber
     * @param string $type
     * @param string $unit
     */
    public function __construct($additionalInfo = null, $count = null, $nationalNumber = null, $type = null, $unit = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setCount($count)
            ->setNationalNumber($nationalNumber)
            ->setType($type)
            ->setUnit($unit);
    }
    /**
     * Get additionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->additionalInfo;
    }
    /**
     * Set additionalInfo value
     * @param string $additionalInfo
     * @return \StructType\DtoSubInfo
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->additionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get count value
     * @return float|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param float $count
     * @return \StructType\DtoSubInfo
     */
    public function setCount($count = null)
    {
        // validation for constraint: float
        if (!is_null($count) && !(is_float($count) || is_numeric($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get nationalNumber value
     * @return string|null
     */
    public function getNationalNumber()
    {
        return $this->nationalNumber;
    }
    /**
     * Set nationalNumber value
     * @param string $nationalNumber
     * @return \StructType\DtoSubInfo
     */
    public function setNationalNumber($nationalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nationalNumber) && !is_string($nationalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalNumber, true), gettype($nationalNumber)), __LINE__);
        }
        $this->nationalNumber = $nationalNumber;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\DtoSubInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \StructType\DtoSubInfo
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoSubInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
