<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoPrescription StructType
 * @subpackage Structs
 */
class DtoPrescription extends AbstractStructBase
{
    /**
     * The dtoSubscriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoSubscription[]
     */
    public $dtoSubscriptions;
    /**
     * Constructor method for dtoPrescription
     * @uses DtoPrescription::setDtoSubscriptions()
     * @param \StructType\DtoSubscription[] $dtoSubscriptions
     */
    public function __construct(array $dtoSubscriptions = array())
    {
        $this
            ->setDtoSubscriptions($dtoSubscriptions);
    }
    /**
     * Get dtoSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoSubscription[]|null
     */
    public function getDtoSubscriptions()
    {
        return isset($this->dtoSubscriptions) ? $this->dtoSubscriptions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDtoSubscriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDtoSubscriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDtoSubscriptionsForArrayConstraintsFromSetDtoSubscriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoPrescriptionDtoSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$dtoPrescriptionDtoSubscriptionsItem instanceof \StructType\DtoSubscription) {
                $invalidValues[] = is_object($dtoPrescriptionDtoSubscriptionsItem) ? get_class($dtoPrescriptionDtoSubscriptionsItem) : sprintf('%s(%s)', gettype($dtoPrescriptionDtoSubscriptionsItem), var_export($dtoPrescriptionDtoSubscriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dtoSubscriptions property can only contain items of type \StructType\DtoSubscription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dtoSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscription[] $dtoSubscriptions
     * @return \StructType\DtoPrescription
     */
    public function setDtoSubscriptions(array $dtoSubscriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($dtoSubscriptionsArrayErrorMessage = self::validateDtoSubscriptionsForArrayConstraintsFromSetDtoSubscriptions($dtoSubscriptions))) {
            throw new \InvalidArgumentException($dtoSubscriptionsArrayErrorMessage, __LINE__);
        }
        if (is_null($dtoSubscriptions) || (is_array($dtoSubscriptions) && empty($dtoSubscriptions))) {
            unset($this->dtoSubscriptions);
        } else {
            $this->dtoSubscriptions = $dtoSubscriptions;
        }
        return $this;
    }
    /**
     * Add item to dtoSubscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\DtoSubscription $item
     * @return \StructType\DtoPrescription
     */
    public function addToDtoSubscriptions(\StructType\DtoSubscription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DtoSubscription) {
            throw new \InvalidArgumentException(sprintf('The dtoSubscriptions property can only contain items of type \StructType\DtoSubscription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dtoSubscriptions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoPrescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
