<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoPartnerInfo StructType
 * @subpackage Structs
 */
class DtoPartnerInfo extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $additionalInfo;
    /**
     * The fixPhoneNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fixPhoneNo;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The nationalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nationalNumber;
    /**
     * The partnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partnerName;
    /**
     * The typeId
     * @var int
     */
    public $typeId;
    /**
     * The typeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typeName;
    /**
     * Constructor method for dtoPartnerInfo
     * @uses DtoPartnerInfo::setAdditionalInfo()
     * @uses DtoPartnerInfo::setFixPhoneNo()
     * @uses DtoPartnerInfo::setId()
     * @uses DtoPartnerInfo::setLastName()
     * @uses DtoPartnerInfo::setName()
     * @uses DtoPartnerInfo::setNationalNumber()
     * @uses DtoPartnerInfo::setPartnerName()
     * @uses DtoPartnerInfo::setTypeId()
     * @uses DtoPartnerInfo::setTypeName()
     * @param string[] $additionalInfo
     * @param string $fixPhoneNo
     * @param int $id
     * @param string $lastName
     * @param string $name
     * @param string $nationalNumber
     * @param string $partnerName
     * @param int $typeId
     * @param string $typeName
     */
    public function __construct(array $additionalInfo = array(), $fixPhoneNo = null, $id = null, $lastName = null, $name = null, $nationalNumber = null, $partnerName = null, $typeId = null, $typeName = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setFixPhoneNo($fixPhoneNo)
            ->setId($id)
            ->setLastName($lastName)
            ->setName($name)
            ->setNationalNumber($nationalNumber)
            ->setPartnerName($partnerName)
            ->setTypeId($typeId)
            ->setTypeName($typeName);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoPartnerInfoAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!is_string($dtoPartnerInfoAdditionalInfoItem)) {
                $invalidValues[] = is_object($dtoPartnerInfoAdditionalInfoItem) ? get_class($dtoPartnerInfoAdditionalInfoItem) : sprintf('%s(%s)', gettype($dtoPartnerInfoAdditionalInfoItem), var_export($dtoPartnerInfoAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $additionalInfo
     * @return \StructType\DtoPartnerInfo
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to additionalInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoPartnerInfo
     */
    public function addToAdditionalInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInfo[] = $item;
        return $this;
    }
    /**
     * Get fixPhoneNo value
     * @return string|null
     */
    public function getFixPhoneNo()
    {
        return $this->fixPhoneNo;
    }
    /**
     * Set fixPhoneNo value
     * @param string $fixPhoneNo
     * @return \StructType\DtoPartnerInfo
     */
    public function setFixPhoneNo($fixPhoneNo = null)
    {
        // validation for constraint: string
        if (!is_null($fixPhoneNo) && !is_string($fixPhoneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fixPhoneNo, true), gettype($fixPhoneNo)), __LINE__);
        }
        $this->fixPhoneNo = $fixPhoneNo;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DtoPartnerInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\DtoPartnerInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DtoPartnerInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get nationalNumber value
     * @return string|null
     */
    public function getNationalNumber()
    {
        return $this->nationalNumber;
    }
    /**
     * Set nationalNumber value
     * @param string $nationalNumber
     * @return \StructType\DtoPartnerInfo
     */
    public function setNationalNumber($nationalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nationalNumber) && !is_string($nationalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalNumber, true), gettype($nationalNumber)), __LINE__);
        }
        $this->nationalNumber = $nationalNumber;
        return $this;
    }
    /**
     * Get partnerName value
     * @return string|null
     */
    public function getPartnerName()
    {
        return $this->partnerName;
    }
    /**
     * Set partnerName value
     * @param string $partnerName
     * @return \StructType\DtoPartnerInfo
     */
    public function setPartnerName($partnerName = null)
    {
        // validation for constraint: string
        if (!is_null($partnerName) && !is_string($partnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerName, true), gettype($partnerName)), __LINE__);
        }
        $this->partnerName = $partnerName;
        return $this;
    }
    /**
     * Get typeId value
     * @return int|null
     */
    public function getTypeId()
    {
        return $this->typeId;
    }
    /**
     * Set typeId value
     * @param int $typeId
     * @return \StructType\DtoPartnerInfo
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: int
        if (!is_null($typeId) && !(is_int($typeId) || ctype_digit($typeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * Get typeName value
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->typeName;
    }
    /**
     * Set typeName value
     * @param string $typeName
     * @return \StructType\DtoPartnerInfo
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeName, true), gettype($typeName)), __LINE__);
        }
        $this->typeName = $typeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoPartnerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
