<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dtoDeliveredSubscription StructType
 * @subpackage Structs
 */
class DtoDeliveredSubscription extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $additionalInfo;
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The checkCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkCode;
    /**
     * The consumption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $consumption;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The numberOfDeliverd
     * @var int
     */
    public $numberOfDeliverd;
    /**
     * The paitentPayment
     * @var float
     */
    public $paitentPayment;
    /**
     * The priceId
     * @var int
     */
    public $priceId;
    /**
     * The refrenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $refrenceId;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for dtoDeliveredSubscription
     * @uses DtoDeliveredSubscription::setAdditionalInfo()
     * @uses DtoDeliveredSubscription::setAmount()
     * @uses DtoDeliveredSubscription::setCheckCode()
     * @uses DtoDeliveredSubscription::setConsumption()
     * @uses DtoDeliveredSubscription::setDescription()
     * @uses DtoDeliveredSubscription::setNumberOfDeliverd()
     * @uses DtoDeliveredSubscription::setPaitentPayment()
     * @uses DtoDeliveredSubscription::setPriceId()
     * @uses DtoDeliveredSubscription::setRefrenceId()
     * @uses DtoDeliveredSubscription::setServiceId()
     * @uses DtoDeliveredSubscription::setUUID()
     * @param string[] $additionalInfo
     * @param float $amount
     * @param string $checkCode
     * @param string $consumption
     * @param string $description
     * @param int $numberOfDeliverd
     * @param float $paitentPayment
     * @param int $priceId
     * @param int $refrenceId
     * @param int $serviceId
     * @param string $uUID
     */
    public function __construct(array $additionalInfo = array(), $amount = null, $checkCode = null, $consumption = null, $description = null, $numberOfDeliverd = null, $paitentPayment = null, $priceId = null, $refrenceId = null, $serviceId = null, $uUID = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setAmount($amount)
            ->setCheckCode($checkCode)
            ->setConsumption($consumption)
            ->setDescription($description)
            ->setNumberOfDeliverd($numberOfDeliverd)
            ->setPaitentPayment($paitentPayment)
            ->setPriceId($priceId)
            ->setRefrenceId($refrenceId)
            ->setServiceId($serviceId)
            ->setUUID($uUID);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dtoDeliveredSubscriptionAdditionalInfoItem) {
            // validation for constraint: itemType
            if (!is_string($dtoDeliveredSubscriptionAdditionalInfoItem)) {
                $invalidValues[] = is_object($dtoDeliveredSubscriptionAdditionalInfoItem) ? get_class($dtoDeliveredSubscriptionAdditionalInfoItem) : sprintf('%s(%s)', gettype($dtoDeliveredSubscriptionAdditionalInfoItem), var_export($dtoDeliveredSubscriptionAdditionalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $additionalInfo
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setAdditionalInfo(array $additionalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoArrayErrorMessage = self::validateAdditionalInfoForArrayConstraintsFromSetAdditionalInfo($additionalInfo))) {
            throw new \InvalidArgumentException($additionalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Add item to additionalInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DtoDeliveredSubscription
     */
    public function addToAdditionalInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The additionalInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInfo[] = $item;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get checkCode value
     * @return string|null
     */
    public function getCheckCode()
    {
        return $this->checkCode;
    }
    /**
     * Set checkCode value
     * @param string $checkCode
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setCheckCode($checkCode = null)
    {
        // validation for constraint: string
        if (!is_null($checkCode) && !is_string($checkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkCode, true), gettype($checkCode)), __LINE__);
        }
        $this->checkCode = $checkCode;
        return $this;
    }
    /**
     * Get consumption value
     * @return string|null
     */
    public function getConsumption()
    {
        return $this->consumption;
    }
    /**
     * Set consumption value
     * @param string $consumption
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: string
        if (!is_null($consumption) && !is_string($consumption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->consumption = $consumption;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberOfDeliverd value
     * @return int|null
     */
    public function getNumberOfDeliverd()
    {
        return $this->numberOfDeliverd;
    }
    /**
     * Set numberOfDeliverd value
     * @param int $numberOfDeliverd
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setNumberOfDeliverd($numberOfDeliverd = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDeliverd) && !(is_int($numberOfDeliverd) || ctype_digit($numberOfDeliverd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDeliverd, true), gettype($numberOfDeliverd)), __LINE__);
        }
        $this->numberOfDeliverd = $numberOfDeliverd;
        return $this;
    }
    /**
     * Get paitentPayment value
     * @return float|null
     */
    public function getPaitentPayment()
    {
        return $this->paitentPayment;
    }
    /**
     * Set paitentPayment value
     * @param float $paitentPayment
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setPaitentPayment($paitentPayment = null)
    {
        // validation for constraint: float
        if (!is_null($paitentPayment) && !(is_float($paitentPayment) || is_numeric($paitentPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paitentPayment, true), gettype($paitentPayment)), __LINE__);
        }
        $this->paitentPayment = $paitentPayment;
        return $this;
    }
    /**
     * Get priceId value
     * @return int|null
     */
    public function getPriceId()
    {
        return $this->priceId;
    }
    /**
     * Set priceId value
     * @param int $priceId
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setPriceId($priceId = null)
    {
        // validation for constraint: int
        if (!is_null($priceId) && !(is_int($priceId) || ctype_digit($priceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceId, true), gettype($priceId)), __LINE__);
        }
        $this->priceId = $priceId;
        return $this;
    }
    /**
     * Get refrenceId value
     * @return int|null
     */
    public function getRefrenceId()
    {
        return $this->refrenceId;
    }
    /**
     * Set refrenceId value
     * @param int $refrenceId
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setRefrenceId($refrenceId = null)
    {
        // validation for constraint: int
        if (!is_null($refrenceId) && !(is_int($refrenceId) || ctype_digit($refrenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refrenceId, true), gettype($refrenceId)), __LINE__);
        }
        $this->refrenceId = $refrenceId;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\DtoDeliveredSubscription
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoDeliveredSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
