<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fetch ServiceType
 * @subpackage Services
 */
class Fetch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * fetchDeliveredPrescriptionByTrackingCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $trackingCode
     * @param string $nationalNumber
     * @return \StructType\DtoDeliveredPrescriptionInfo|bool
     */
    public function fetchDeliveredPrescriptionByTrackingCode(\StructType\DtoClientInfo $dtoClientInfo, $trackingCode, $nationalNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->fetchDeliveredPrescriptionByTrackingCode($dtoClientInfo, $trackingCode, $nationalNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named fetchPartnerInfoByPrintCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $printCode
     * @return \StructType\DtoPartnerInfoWrapper|bool
     */
    public function fetchPartnerInfoByPrintCode(\StructType\DtoClientInfo $dtoClientInfo, $printCode)
    {
        try {
            $this->setResult($this->getSoapClient()->fetchPartnerInfoByPrintCode($dtoClientInfo, $printCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named fetchPresriptionInfoByPrintCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $printCode
     * @param string $citizenSessionId
     * @return \StructType\DtoPrescriptionInfo|bool
     */
    public function fetchPresriptionInfoByPrintCode(\StructType\DtoClientInfo $dtoClientInfo, $printCode, $citizenSessionId)
    {
        try {
            $this->setResult($this->getSoapClient()->fetchPresriptionInfoByPrintCode($dtoClientInfo, $printCode, $citizenSessionId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named fetchPresriptionInfoBySamadCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DtoClientInfo $dtoClientInfo
     * @param string $samadCode
     * @param string $citizenSessionId
     * @return \StructType\DtoPrescriptionInfo|bool
     */
    public function fetchPresriptionInfoBySamadCode(\StructType\DtoClientInfo $dtoClientInfo, $samadCode, $citizenSessionId)
    {
        try {
            $this->setResult($this->getSoapClient()->fetchPresriptionInfoBySamadCode($dtoClientInfo, $samadCode, $citizenSessionId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DtoDeliveredPrescriptionInfo|\StructType\DtoPartnerInfoWrapper|\StructType\DtoPrescriptionInfo
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
