<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productAndServiceData StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles product and service data for ShipmentService.
 * @subpackage Structs
 */
class ProductAndServiceData extends AbstractStructBase
{
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $orderType;
    /**
     * The saturdayDelivery
     * Meta information extracted from the WSDL
     * - documentation: Specifies if saturday delivery is demanded. Only selectable for product "E12". Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $saturdayDelivery;
    /**
     * The exWorksDelivery
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the recipient has to pay the consignment. Default value is false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $exWorksDelivery;
    /**
     * The guarantee
     * Meta information extracted from the WSDL
     * - documentation: Set to true if an international shipment should use Guarantee, only for products CL and E18 for international parcels.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $guarantee;
    /**
     * The tyres
     * Meta information extracted from the WSDL
     * - documentation: Set to true if this consignment contains bulk tyres, only for product CL.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $tyres;
    /**
     * The food
     * Meta information extracted from the WSDL
     * - documentation: Set to true if the parcel should deliver as product 'DPD Food'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $food;
    /**
     * The personalDelivery
     * Meta information extracted from the WSDL
     * - documentation: Contains information for personal delivery.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\PersonalDelivery
     */
    public $personalDelivery;
    /**
     * The pickup
     * Meta information extracted from the WSDL
     * - documentation: Contains information for pickup consignments, pickup address for collection requests or details for pickup information.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Pickup
     */
    public $pickup;
    /**
     * The parcelShopDelivery
     * Meta information extracted from the WSDL
     * - documentation: Contains the necessary information, if a parcel shop delivery is intended.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\ParcelShopDelivery
     */
    public $parcelShopDelivery;
    /**
     * The predict
     * Meta information extracted from the WSDL
     * - documentation: Contains data for interactive notification for consignments. The notification type "phone" is forbidden here.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Notification
     */
    public $predict;
    /**
     * The personalDeliveryNotification
     * Meta information extracted from the WSDL
     * - documentation: Contains data for personal delivery notification for consignments.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Notification
     */
    public $personalDeliveryNotification;
    /**
     * The proactiveNotification
     * Meta information extracted from the WSDL
     * - documentation: Contains information of proactive notification for consignments.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\ProactiveNotification[]
     */
    public $proactiveNotification;
    /**
     * The delivery
     * Meta information extracted from the WSDL
     * - documentation: Contains special delivery data for consignments.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Delivery
     */
    public $delivery;
    /**
     * The invoiceAddress
     * Meta information extracted from the WSDL
     * - documentation: Contains data about invoice recipient if it differs for consignment.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Address
     */
    public $invoiceAddress;
    /**
     * The countrySpecificService
     * Meta information extracted from the WSDL
     * - documentation: In some relations a specific service code can be set, which overwrites the feature selection.
     * - minOccurs: 0
     * @var string
     */
    public $countrySpecificService;
    /**
     * Constructor method for productAndServiceData
     * @uses ProductAndServiceData::setOrderType()
     * @uses ProductAndServiceData::setSaturdayDelivery()
     * @uses ProductAndServiceData::setExWorksDelivery()
     * @uses ProductAndServiceData::setGuarantee()
     * @uses ProductAndServiceData::setTyres()
     * @uses ProductAndServiceData::setFood()
     * @uses ProductAndServiceData::setPersonalDelivery()
     * @uses ProductAndServiceData::setPickup()
     * @uses ProductAndServiceData::setParcelShopDelivery()
     * @uses ProductAndServiceData::setPredict()
     * @uses ProductAndServiceData::setPersonalDeliveryNotification()
     * @uses ProductAndServiceData::setProactiveNotification()
     * @uses ProductAndServiceData::setDelivery()
     * @uses ProductAndServiceData::setInvoiceAddress()
     * @uses ProductAndServiceData::setCountrySpecificService()
     * @param string $orderType
     * @param bool $saturdayDelivery
     * @param bool $exWorksDelivery
     * @param bool $guarantee
     * @param bool $tyres
     * @param bool $food
     * @param \dpd\Shipment\StructType\PersonalDelivery $personalDelivery
     * @param \dpd\Shipment\StructType\Pickup $pickup
     * @param \dpd\Shipment\StructType\ParcelShopDelivery $parcelShopDelivery
     * @param \dpd\Shipment\StructType\Notification $predict
     * @param \dpd\Shipment\StructType\Notification $personalDeliveryNotification
     * @param \dpd\Shipment\StructType\ProactiveNotification[] $proactiveNotification
     * @param \dpd\Shipment\StructType\Delivery $delivery
     * @param \dpd\Shipment\StructType\Address $invoiceAddress
     * @param string $countrySpecificService
     */
    public function __construct($orderType = null, $saturdayDelivery = null, $exWorksDelivery = null, $guarantee = null, $tyres = null, $food = null, \dpd\Shipment\StructType\PersonalDelivery $personalDelivery = null, \dpd\Shipment\StructType\Pickup $pickup = null, \dpd\Shipment\StructType\ParcelShopDelivery $parcelShopDelivery = null, \dpd\Shipment\StructType\Notification $predict = null, \dpd\Shipment\StructType\Notification $personalDeliveryNotification = null, array $proactiveNotification = array(), \dpd\Shipment\StructType\Delivery $delivery = null, \dpd\Shipment\StructType\Address $invoiceAddress = null, $countrySpecificService = null)
    {
        $this
            ->setOrderType($orderType)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setExWorksDelivery($exWorksDelivery)
            ->setGuarantee($guarantee)
            ->setTyres($tyres)
            ->setFood($food)
            ->setPersonalDelivery($personalDelivery)
            ->setPickup($pickup)
            ->setParcelShopDelivery($parcelShopDelivery)
            ->setPredict($predict)
            ->setPersonalDeliveryNotification($personalDeliveryNotification)
            ->setProactiveNotification($proactiveNotification)
            ->setDelivery($delivery)
            ->setInvoiceAddress($invoiceAddress)
            ->setCountrySpecificService($countrySpecificService);
    }
    /**
     * Get orderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @uses \dpd\Shipment\EnumType\OrderType::valueIsValid()
     * @uses \dpd\Shipment\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \dpd\Shipment\EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get saturdayDelivery value
     * @return bool|null
     */
    public function getSaturdayDelivery()
    {
        return $this->saturdayDelivery;
    }
    /**
     * Set saturdayDelivery value
     * @param bool $saturdayDelivery
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setSaturdayDelivery($saturdayDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayDelivery) && !is_bool($saturdayDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturdayDelivery, true), gettype($saturdayDelivery)), __LINE__);
        }
        $this->saturdayDelivery = $saturdayDelivery;
        return $this;
    }
    /**
     * Get exWorksDelivery value
     * @return bool|null
     */
    public function getExWorksDelivery()
    {
        return $this->exWorksDelivery;
    }
    /**
     * Set exWorksDelivery value
     * @param bool $exWorksDelivery
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setExWorksDelivery($exWorksDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($exWorksDelivery) && !is_bool($exWorksDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exWorksDelivery, true), gettype($exWorksDelivery)), __LINE__);
        }
        $this->exWorksDelivery = $exWorksDelivery;
        return $this;
    }
    /**
     * Get guarantee value
     * @return bool|null
     */
    public function getGuarantee()
    {
        return $this->guarantee;
    }
    /**
     * Set guarantee value
     * @param bool $guarantee
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setGuarantee($guarantee = null)
    {
        // validation for constraint: boolean
        if (!is_null($guarantee) && !is_bool($guarantee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guarantee, true), gettype($guarantee)), __LINE__);
        }
        $this->guarantee = $guarantee;
        return $this;
    }
    /**
     * Get tyres value
     * @return bool|null
     */
    public function getTyres()
    {
        return $this->tyres;
    }
    /**
     * Set tyres value
     * @param bool $tyres
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setTyres($tyres = null)
    {
        // validation for constraint: boolean
        if (!is_null($tyres) && !is_bool($tyres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tyres, true), gettype($tyres)), __LINE__);
        }
        $this->tyres = $tyres;
        return $this;
    }
    /**
     * Get food value
     * @return bool|null
     */
    public function getFood()
    {
        return $this->food;
    }
    /**
     * Set food value
     * @param bool $food
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setFood($food = null)
    {
        // validation for constraint: boolean
        if (!is_null($food) && !is_bool($food)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($food, true), gettype($food)), __LINE__);
        }
        $this->food = $food;
        return $this;
    }
    /**
     * Get personalDelivery value
     * @return \dpd\Shipment\StructType\PersonalDelivery|null
     */
    public function getPersonalDelivery()
    {
        return $this->personalDelivery;
    }
    /**
     * Set personalDelivery value
     * @param \dpd\Shipment\StructType\PersonalDelivery $personalDelivery
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setPersonalDelivery(\dpd\Shipment\StructType\PersonalDelivery $personalDelivery = null)
    {
        $this->personalDelivery = $personalDelivery;
        return $this;
    }
    /**
     * Get pickup value
     * @return \dpd\Shipment\StructType\Pickup|null
     */
    public function getPickup()
    {
        return $this->pickup;
    }
    /**
     * Set pickup value
     * @param \dpd\Shipment\StructType\Pickup $pickup
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setPickup(\dpd\Shipment\StructType\Pickup $pickup = null)
    {
        $this->pickup = $pickup;
        return $this;
    }
    /**
     * Get parcelShopDelivery value
     * @return \dpd\Shipment\StructType\ParcelShopDelivery|null
     */
    public function getParcelShopDelivery()
    {
        return $this->parcelShopDelivery;
    }
    /**
     * Set parcelShopDelivery value
     * @param \dpd\Shipment\StructType\ParcelShopDelivery $parcelShopDelivery
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setParcelShopDelivery(\dpd\Shipment\StructType\ParcelShopDelivery $parcelShopDelivery = null)
    {
        $this->parcelShopDelivery = $parcelShopDelivery;
        return $this;
    }
    /**
     * Get predict value
     * @return \dpd\Shipment\StructType\Notification|null
     */
    public function getPredict()
    {
        return $this->predict;
    }
    /**
     * Set predict value
     * @param \dpd\Shipment\StructType\Notification $predict
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setPredict(\dpd\Shipment\StructType\Notification $predict = null)
    {
        $this->predict = $predict;
        return $this;
    }
    /**
     * Get personalDeliveryNotification value
     * @return \dpd\Shipment\StructType\Notification|null
     */
    public function getPersonalDeliveryNotification()
    {
        return $this->personalDeliveryNotification;
    }
    /**
     * Set personalDeliveryNotification value
     * @param \dpd\Shipment\StructType\Notification $personalDeliveryNotification
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setPersonalDeliveryNotification(\dpd\Shipment\StructType\Notification $personalDeliveryNotification = null)
    {
        $this->personalDeliveryNotification = $personalDeliveryNotification;
        return $this;
    }
    /**
     * Get proactiveNotification value
     * @return \dpd\Shipment\StructType\ProactiveNotification[]|null
     */
    public function getProactiveNotification()
    {
        return $this->proactiveNotification;
    }
    /**
     * This method is responsible for validating the values passed to the setProactiveNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProactiveNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProactiveNotificationForArrayConstraintsFromSetProactiveNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productAndServiceDataProactiveNotificationItem) {
            // validation for constraint: itemType
            if (!$productAndServiceDataProactiveNotificationItem instanceof \dpd\Shipment\StructType\ProactiveNotification) {
                $invalidValues[] = is_object($productAndServiceDataProactiveNotificationItem) ? get_class($productAndServiceDataProactiveNotificationItem) : sprintf('%s(%s)', gettype($productAndServiceDataProactiveNotificationItem), var_export($productAndServiceDataProactiveNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The proactiveNotification property can only contain items of type \dpd\Shipment\StructType\ProactiveNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set proactiveNotification value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\ProactiveNotification[] $proactiveNotification
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setProactiveNotification(array $proactiveNotification = array())
    {
        // validation for constraint: array
        if ('' !== ($proactiveNotificationArrayErrorMessage = self::validateProactiveNotificationForArrayConstraintsFromSetProactiveNotification($proactiveNotification))) {
            throw new \InvalidArgumentException($proactiveNotificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($proactiveNotification) && count($proactiveNotification) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($proactiveNotification)), __LINE__);
        }
        $this->proactiveNotification = $proactiveNotification;
        return $this;
    }
    /**
     * Add item to proactiveNotification value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\ProactiveNotification $item
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function addToProactiveNotification(\dpd\Shipment\StructType\ProactiveNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\Shipment\StructType\ProactiveNotification) {
            throw new \InvalidArgumentException(sprintf('The proactiveNotification property can only contain items of type \dpd\Shipment\StructType\ProactiveNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->proactiveNotification) && count($this->proactiveNotification) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->proactiveNotification)), __LINE__);
        }
        $this->proactiveNotification[] = $item;
        return $this;
    }
    /**
     * Get delivery value
     * @return \dpd\Shipment\StructType\Delivery|null
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @param \dpd\Shipment\StructType\Delivery $delivery
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setDelivery(\dpd\Shipment\StructType\Delivery $delivery = null)
    {
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Get invoiceAddress value
     * @return \dpd\Shipment\StructType\Address|null
     */
    public function getInvoiceAddress()
    {
        return $this->invoiceAddress;
    }
    /**
     * Set invoiceAddress value
     * @param \dpd\Shipment\StructType\Address $invoiceAddress
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setInvoiceAddress(\dpd\Shipment\StructType\Address $invoiceAddress = null)
    {
        $this->invoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get countrySpecificService value
     * @return string|null
     */
    public function getCountrySpecificService()
    {
        return $this->countrySpecificService;
    }
    /**
     * Set countrySpecificService value
     * @param string $countrySpecificService
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public function setCountrySpecificService($countrySpecificService = null)
    {
        // validation for constraint: string
        if (!is_null($countrySpecificService) && !is_string($countrySpecificService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySpecificService, true), gettype($countrySpecificService)), __LINE__);
        }
        $this->countrySpecificService = $countrySpecificService;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\ProductAndServiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
