<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Options how to return the parcel labels
 * @subpackage Structs
 */
class PrintOptions extends AbstractStructBase
{
    /**
     * The printOption
     * Meta information extracted from the WSDL
     * - documentation: The formats in which the parcel labels should be returned. If more than one format is set, the option splitByParcel is set implicitly.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \dpd\Shipment\StructType\PrintOption[]
     */
    public $printOption;
    /**
     * The splitByParcel
     * Meta information extracted from the WSDL
     * - documentation: Determines whether a complete parcel label sheet will be created or a single one for each parcel.If format is BARCODE_IMAGE then this is set implicitly.
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $splitByParcel;
    /**
     * Constructor method for printOptions
     * @uses PrintOptions::setPrintOption()
     * @uses PrintOptions::setSplitByParcel()
     * @param \dpd\Shipment\StructType\PrintOption[] $printOption
     * @param bool $splitByParcel
     */
    public function __construct(array $printOption = array(), $splitByParcel = false)
    {
        $this
            ->setPrintOption($printOption)
            ->setSplitByParcel($splitByParcel);
    }
    /**
     * Get printOption value
     * @return \dpd\Shipment\StructType\PrintOption[]
     */
    public function getPrintOption()
    {
        return $this->printOption;
    }
    /**
     * This method is responsible for validating the values passed to the setPrintOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrintOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrintOptionForArrayConstraintsFromSetPrintOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printOptionsPrintOptionItem) {
            // validation for constraint: itemType
            if (!$printOptionsPrintOptionItem instanceof \dpd\Shipment\StructType\PrintOption) {
                $invalidValues[] = is_object($printOptionsPrintOptionItem) ? get_class($printOptionsPrintOptionItem) : sprintf('%s(%s)', gettype($printOptionsPrintOptionItem), var_export($printOptionsPrintOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The printOption property can only contain items of type \dpd\Shipment\StructType\PrintOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set printOption value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\PrintOption[] $printOption
     * @return \dpd\Shipment\StructType\PrintOptions
     */
    public function setPrintOption(array $printOption = array())
    {
        // validation for constraint: array
        if ('' !== ($printOptionArrayErrorMessage = self::validatePrintOptionForArrayConstraintsFromSetPrintOption($printOption))) {
            throw new \InvalidArgumentException($printOptionArrayErrorMessage, __LINE__);
        }
        $this->printOption = $printOption;
        return $this;
    }
    /**
     * Add item to printOption value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\PrintOption $item
     * @return \dpd\Shipment\StructType\PrintOptions
     */
    public function addToPrintOption(\dpd\Shipment\StructType\PrintOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\Shipment\StructType\PrintOption) {
            throw new \InvalidArgumentException(sprintf('The printOption property can only contain items of type \dpd\Shipment\StructType\PrintOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->printOption[] = $item;
        return $this;
    }
    /**
     * Get splitByParcel value
     * @return bool|null
     */
    public function getSplitByParcel()
    {
        return $this->splitByParcel;
    }
    /**
     * Set splitByParcel value
     * @param bool $splitByParcel
     * @return \dpd\Shipment\StructType\PrintOptions
     */
    public function setSplitByParcel($splitByParcel = false)
    {
        // validation for constraint: boolean
        if (!is_null($splitByParcel) && !is_bool($splitByParcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($splitByParcel, true), gettype($splitByParcel)), __LINE__);
        }
        $this->splitByParcel = $splitByParcel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\PrintOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
