<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickup StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles pickup data.
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - documentation: Quantity of pickup parcels. Mandatory for consignment.
     * - base: xs:int
     * - maxInclusive: 99999
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Pickup date in consignments and collection requests. The collection day for advice customers. The from date for pickup information. Format is YYYYMMDD.It can also be used as pickup date for collection requests, then format is YYMMDD.
     * Mandatory for consignment.
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 1
     * @var int
     */
    public $date;
    /**
     * The day
     * Meta information extracted from the WSDL
     * - documentation: Allowed delivery days in the week (0 = Sunday, 1 = Monday etc.).Comma separated list of possible delivery days (e.g. "2,3,4,5"). | Pickup day of week for consignments and pickup information. Allowed values are 0..6 (0=Sunday,
     * 1=Monday, etc.). Mandatory for consignment.
     * - base: xs:int
     * - maxInclusive: 6
     * - minOccurs: 1
     * @var int
     */
    public $day;
    /**
     * The tour
     * Meta information extracted from the WSDL
     * - documentation: Tour number (between 000 and 999).
     * - base: xs:int
     * - maxInclusive: 999
     * - minOccurs: 0
     * @var int
     */
    public $tour;
    /**
     * The fromTime1
     * Meta information extracted from the WSDL
     * - documentation: From time 1 for consignments and pickup information. Format is hhmm. Mandatory for consignment and variable consignor address.
     * - base: xs:int
     * - maxInclusive: 2400
     * - minOccurs: 0
     * @var int
     */
    public $fromTime1;
    /**
     * The toTime1
     * Meta information extracted from the WSDL
     * - documentation: Until time 1 for consignments and pickup information. Format is hhmm. Mandatory for consignment and variable consignor address.
     * - base: xs:int
     * - maxInclusive: 2400
     * - minOccurs: 0
     * @var int
     */
    public $toTime1;
    /**
     * The fromTime2
     * Meta information extracted from the WSDL
     * - documentation: From time 2 for consignments and pickup information. Format is hhmm.
     * - base: xs:int
     * - maxInclusive: 2400
     * - minOccurs: 0
     * @var int
     */
    public $fromTime2;
    /**
     * The toTime2
     * Meta information extracted from the WSDL
     * - documentation: Until time 2 for consignments and pickup information. Format is hhmm.
     * - base: xs:int
     * - maxInclusive: 2400
     * - minOccurs: 0
     * @var int
     */
    public $toTime2;
    /**
     * The extraPickup
     * Meta information extracted from the WSDL
     * - documentation: Detemines whether an extra pickup tour is created for this shipment with express service.Possible values are:1: Extra pickup without express service2: Extra pickup with express service
     * - base: xs:int
     * - maxInclusive: 2
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $extraPickup;
    /**
     * The boxId
     * Meta information extracted from the WSDL
     * - documentation: The ID of the parcel box.
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $boxId;
    /**
     * The boxTan
     * Meta information extracted from the WSDL
     * - documentation: The TAN of the parcel box for this order.
     * - base: xs:string
     * - maxLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $boxTan;
    /**
     * The collectionRequestAddress
     * Meta information extracted from the WSDL
     * - documentation: Contains pickup address information for consignments and collection requests. Mandatory for consignment.
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Address
     */
    public $collectionRequestAddress;
    /**
     * Constructor method for pickup
     * @uses Pickup::setQuantity()
     * @uses Pickup::setDate()
     * @uses Pickup::setDay()
     * @uses Pickup::setTour()
     * @uses Pickup::setFromTime1()
     * @uses Pickup::setToTime1()
     * @uses Pickup::setFromTime2()
     * @uses Pickup::setToTime2()
     * @uses Pickup::setExtraPickup()
     * @uses Pickup::setBoxId()
     * @uses Pickup::setBoxTan()
     * @uses Pickup::setCollectionRequestAddress()
     * @param int $quantity
     * @param int $date
     * @param int $day
     * @param int $tour
     * @param int $fromTime1
     * @param int $toTime1
     * @param int $fromTime2
     * @param int $toTime2
     * @param int $extraPickup
     * @param string $boxId
     * @param string $boxTan
     * @param \dpd\Shipment\StructType\Address $collectionRequestAddress
     */
    public function __construct($quantity = null, $date = null, $day = null, $tour = null, $fromTime1 = null, $toTime1 = null, $fromTime2 = null, $toTime2 = null, $extraPickup = null, $boxId = null, $boxTan = null, \dpd\Shipment\StructType\Address $collectionRequestAddress = null)
    {
        $this
            ->setQuantity($quantity)
            ->setDate($date)
            ->setDay($day)
            ->setTour($tour)
            ->setFromTime1($fromTime1)
            ->setToTime1($toTime1)
            ->setFromTime2($fromTime2)
            ->setToTime2($toTime2)
            ->setExtraPickup($extraPickup)
            ->setBoxId($boxId)
            ->setBoxTan($boxTan)
            ->setCollectionRequestAddress($collectionRequestAddress);
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999)
        if (!is_null($quantity) && $quantity > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get date value
     * @return int
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param int $date
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setDate($date = null)
    {
        // validation for constraint: int
        if (!is_null($date) && !(is_int($date) || ctype_digit($date))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($date) && $date > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get day value
     * @return int
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        // validation for constraint: maxInclusive(6)
        if (!is_null($day) && $day > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 6', var_export($day, true)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get tour value
     * @return int|null
     */
    public function getTour()
    {
        return $this->tour;
    }
    /**
     * Set tour value
     * @param int $tour
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setTour($tour = null)
    {
        // validation for constraint: int
        if (!is_null($tour) && !(is_int($tour) || ctype_digit($tour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tour, true), gettype($tour)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($tour) && $tour > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($tour, true)), __LINE__);
        }
        $this->tour = $tour;
        return $this;
    }
    /**
     * Get fromTime1 value
     * @return int|null
     */
    public function getFromTime1()
    {
        return $this->fromTime1;
    }
    /**
     * Set fromTime1 value
     * @param int $fromTime1
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setFromTime1($fromTime1 = null)
    {
        // validation for constraint: int
        if (!is_null($fromTime1) && !(is_int($fromTime1) || ctype_digit($fromTime1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTime1, true), gettype($fromTime1)), __LINE__);
        }
        // validation for constraint: maxInclusive(2400)
        if (!is_null($fromTime1) && $fromTime1 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2400', var_export($fromTime1, true)), __LINE__);
        }
        $this->fromTime1 = $fromTime1;
        return $this;
    }
    /**
     * Get toTime1 value
     * @return int|null
     */
    public function getToTime1()
    {
        return $this->toTime1;
    }
    /**
     * Set toTime1 value
     * @param int $toTime1
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setToTime1($toTime1 = null)
    {
        // validation for constraint: int
        if (!is_null($toTime1) && !(is_int($toTime1) || ctype_digit($toTime1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTime1, true), gettype($toTime1)), __LINE__);
        }
        // validation for constraint: maxInclusive(2400)
        if (!is_null($toTime1) && $toTime1 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2400', var_export($toTime1, true)), __LINE__);
        }
        $this->toTime1 = $toTime1;
        return $this;
    }
    /**
     * Get fromTime2 value
     * @return int|null
     */
    public function getFromTime2()
    {
        return $this->fromTime2;
    }
    /**
     * Set fromTime2 value
     * @param int $fromTime2
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setFromTime2($fromTime2 = null)
    {
        // validation for constraint: int
        if (!is_null($fromTime2) && !(is_int($fromTime2) || ctype_digit($fromTime2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTime2, true), gettype($fromTime2)), __LINE__);
        }
        // validation for constraint: maxInclusive(2400)
        if (!is_null($fromTime2) && $fromTime2 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2400', var_export($fromTime2, true)), __LINE__);
        }
        $this->fromTime2 = $fromTime2;
        return $this;
    }
    /**
     * Get toTime2 value
     * @return int|null
     */
    public function getToTime2()
    {
        return $this->toTime2;
    }
    /**
     * Set toTime2 value
     * @param int $toTime2
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setToTime2($toTime2 = null)
    {
        // validation for constraint: int
        if (!is_null($toTime2) && !(is_int($toTime2) || ctype_digit($toTime2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTime2, true), gettype($toTime2)), __LINE__);
        }
        // validation for constraint: maxInclusive(2400)
        if (!is_null($toTime2) && $toTime2 > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2400', var_export($toTime2, true)), __LINE__);
        }
        $this->toTime2 = $toTime2;
        return $this;
    }
    /**
     * Get extraPickup value
     * @return int|null
     */
    public function getExtraPickup()
    {
        return $this->extraPickup;
    }
    /**
     * Set extraPickup value
     * @param int $extraPickup
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setExtraPickup($extraPickup = null)
    {
        // validation for constraint: int
        if (!is_null($extraPickup) && !(is_int($extraPickup) || ctype_digit($extraPickup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extraPickup, true), gettype($extraPickup)), __LINE__);
        }
        // validation for constraint: maxInclusive(2)
        if (!is_null($extraPickup) && $extraPickup > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2', var_export($extraPickup, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($extraPickup) && $extraPickup < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($extraPickup, true)), __LINE__);
        }
        $this->extraPickup = $extraPickup;
        return $this;
    }
    /**
     * Get boxId value
     * @return string|null
     */
    public function getBoxId()
    {
        return $this->boxId;
    }
    /**
     * Set boxId value
     * @param string $boxId
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setBoxId($boxId = null)
    {
        // validation for constraint: string
        if (!is_null($boxId) && !is_string($boxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxId, true), gettype($boxId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($boxId) && mb_strlen($boxId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($boxId)), __LINE__);
        }
        $this->boxId = $boxId;
        return $this;
    }
    /**
     * Get boxTan value
     * @return string|null
     */
    public function getBoxTan()
    {
        return $this->boxTan;
    }
    /**
     * Set boxTan value
     * @param string $boxTan
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setBoxTan($boxTan = null)
    {
        // validation for constraint: string
        if (!is_null($boxTan) && !is_string($boxTan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxTan, true), gettype($boxTan)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($boxTan) && mb_strlen($boxTan) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($boxTan)), __LINE__);
        }
        $this->boxTan = $boxTan;
        return $this;
    }
    /**
     * Get collectionRequestAddress value
     * @return \dpd\Shipment\StructType\Address|null
     */
    public function getCollectionRequestAddress()
    {
        return $this->collectionRequestAddress;
    }
    /**
     * Set collectionRequestAddress value
     * @param \dpd\Shipment\StructType\Address $collectionRequestAddress
     * @return \dpd\Shipment\StructType\Pickup
     */
    public function setCollectionRequestAddress(\dpd\Shipment\StructType\Address $collectionRequestAddress = null)
    {
        $this->collectionRequestAddress = $collectionRequestAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\Pickup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
