<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personalDelivery StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles personal delivery data.
 * @subpackage Structs
 */
class PersonalDelivery extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Declares type of personal delivery.Possible values are:1 = Department delivery (without personal identification),2 = Personal delivery with personal identification (ID-Check),3 = Personal delivery without personal identification at
     * drop point (e.g. parcel shop),4 = Personal delivery with personal identification at drop point (e.g. parcel shop),5 = Personal delivery with personal identification at drop point plus ID-Check (e.g. parcel shop).For parcel shop delivery the parcel
     * shop id must be declared in productAndServiceData. It can be obtained from parcel shop finder.
     * - base: xs:int
     * - maxInclusive: 5
     * - minInclusive: 1
     * - minOccurs: 1
     * @var int
     */
    public $type;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - documentation: Floor where the personal delivery shall take place. This field is only used for department delivery.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $floor;
    /**
     * The building
     * Meta information extracted from the WSDL
     * - documentation: Building where the personal delivery shall take place. This field is only used for department delivery (type 1).
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $building;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - documentation: Department where the personal delivery shall take place. This field is only used for department delivery (type 1).
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name of the person authorised to accept the consignment. This field is only used for delivery with ID-Check (types 2 and 5).
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Phone number of address owner. Mandatory if phone is the chosen notification channel.If SMS notification is chosen, either mobile or phone must be filled. | Telephone number of the person authorised to accept the consignment. This
     * field is only used for delivery with ID-Check (types 2 and 5).
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The personId
     * Meta information extracted from the WSDL
     * - documentation: Personal identification number of the person authorised to accept the consignment. This field is only used for delivery with ID-Check (types 2 and 5).
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $personId;
    /**
     * Constructor method for personalDelivery
     * @uses PersonalDelivery::setType()
     * @uses PersonalDelivery::setFloor()
     * @uses PersonalDelivery::setBuilding()
     * @uses PersonalDelivery::setDepartment()
     * @uses PersonalDelivery::setName()
     * @uses PersonalDelivery::setPhone()
     * @uses PersonalDelivery::setPersonId()
     * @param int $type
     * @param string $floor
     * @param string $building
     * @param string $department
     * @param string $name
     * @param string $phone
     * @param string $personId
     */
    public function __construct($type = null, $floor = null, $building = null, $department = null, $name = null, $phone = null, $personId = null)
    {
        $this
            ->setType($type)
            ->setFloor($floor)
            ->setBuilding($building)
            ->setDepartment($department)
            ->setName($name)
            ->setPhone($phone)
            ->setPersonId($personId);
    }
    /**
     * Get type value
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxInclusive(5)
        if (!is_null($type) && $type > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 5', var_export($type, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($type) && $type < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($type, true)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($floor) && mb_strlen($floor) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($building) && mb_strlen($building) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($department) && mb_strlen($department) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name) && mb_strlen($name) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get personId value
     * @return string|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param string $personId
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personId, true), gettype($personId)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($personId) && mb_strlen($personId) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\PersonalDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
