<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelShopDelivery StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles parcel shop delivery data.
 * @subpackage Structs
 */
class ParcelShopDelivery extends AbstractStructBase
{
    /**
     * The parcelShopId
     * Meta information extracted from the WSDL
     * - documentation: Parcel shop ID for parcel shop delivery.Can be obtained from parcel shop finder. Assumes that parameter type ofpersonal delivery is filled with a value from 3 to 5,which means parcel shop delivery. Mandatory in this case.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $parcelShopId;
    /**
     * The parcelShopNotification
     * Meta information extracted from the WSDL
     * - documentation: Contains data for personal notification for parcel shop consignments.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \dpd\Shipment\StructType\Notification
     */
    public $parcelShopNotification;
    /**
     * Constructor method for parcelShopDelivery
     * @uses ParcelShopDelivery::setParcelShopId()
     * @uses ParcelShopDelivery::setParcelShopNotification()
     * @param int $parcelShopId
     * @param \dpd\Shipment\StructType\Notification $parcelShopNotification
     */
    public function __construct($parcelShopId = null, \dpd\Shipment\StructType\Notification $parcelShopNotification = null)
    {
        $this
            ->setParcelShopId($parcelShopId)
            ->setParcelShopNotification($parcelShopNotification);
    }
    /**
     * Get parcelShopId value
     * @return int
     */
    public function getParcelShopId()
    {
        return $this->parcelShopId;
    }
    /**
     * Set parcelShopId value
     * @param int $parcelShopId
     * @return \dpd\Shipment\StructType\ParcelShopDelivery
     */
    public function setParcelShopId($parcelShopId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelShopId) && !(is_int($parcelShopId) || ctype_digit($parcelShopId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelShopId, true), gettype($parcelShopId)), __LINE__);
        }
        $this->parcelShopId = $parcelShopId;
        return $this;
    }
    /**
     * Get parcelShopNotification value
     * @return \dpd\Shipment\StructType\Notification
     */
    public function getParcelShopNotification()
    {
        return $this->parcelShopNotification;
    }
    /**
     * Set parcelShopNotification value
     * @param \dpd\Shipment\StructType\Notification $parcelShopNotification
     * @return \dpd\Shipment\StructType\ParcelShopDelivery
     */
    public function setParcelShopNotification(\dpd\Shipment\StructType\Notification $parcelShopNotification = null)
    {
        $this->parcelShopNotification = $parcelShopNotification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\ParcelShopDelivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
