<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hazardous StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles hazardous materials data.
 * @subpackage Structs
 */
class Hazardous extends AbstractStructBase
{
    /**
     * The identificationUnNo
     * Meta information extracted from the WSDL
     * - documentation: Defines UN number of hazardous substance. UN numbers range between 0004 and 9004.
     * - base: xs:string
     * - length: 4
     * - minOccurs: 1
     * @var string
     */
    public $identificationUnNo;
    /**
     * The identificationClass
     * Meta information extracted from the WSDL
     * - documentation: Declares class of hazardous substance. Possible values range from 1 to 9. Subclasses are specified as position after decimal point(e.g. class 1 is "explosives", class 1.6 is "extremely insensitive explosives").
     * - base: xs:string
     * - maxLength: 6
     * - minOccurs: 1
     * @var string
     */
    public $identificationClass;
    /**
     * The packingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $packingCode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Description of hazardous substance (redundant).
     * - base: xs:string
     * - maxLength: 160
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The hazardousWeight
     * Meta information extracted from the WSDL
     * - documentation: Weight of hazardous substance with up to 4 pre-decimal point positions and 2 decimal digits with separator.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minOccurs: 1
     * - totalDigits: 6
     * @var float
     */
    public $hazardousWeight;
    /**
     * The factor
     * Meta information extracted from the WSDL
     * - documentation: Factor of hazardous substance, 999 means unlimited.
     * - base: xs:int
     * - maxInclusive: 999
     * - minOccurs: 1
     * @var int
     */
    public $factor;
    /**
     * The classificationCode
     * Meta information extracted from the WSDL
     * - documentation: Declares classification code of hazardous substance.
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $classificationCode;
    /**
     * The packingGroup
     * Meta information extracted from the WSDL
     * - documentation: Declares packing group of hazardous substance. Valid values are "I", "II" and "III".
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $packingGroup;
    /**
     * The subsidiaryRisk
     * Meta information extracted from the WSDL
     * - documentation: Subsidiary risk of hazardous substance (redundant).
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $subsidiaryRisk;
    /**
     * The tunnelRestrictionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tunnelRestrictionCode;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - documentation: Net weight of hazardous substance with up to 4 pre-decimal point positions and 2 decimal point positions.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $netWeight;
    /**
     * The notOtherwiseSpecified
     * Meta information extracted from the WSDL
     * - documentation: A not otherwise specified text which is mandatory for some substances.
     * - base: xs:string
     * - maxLength: 150
     * - minOccurs: 0
     * @var string
     */
    public $notOtherwiseSpecified;
    /**
     * Constructor method for hazardous
     * @uses Hazardous::setIdentificationUnNo()
     * @uses Hazardous::setIdentificationClass()
     * @uses Hazardous::setPackingCode()
     * @uses Hazardous::setDescription()
     * @uses Hazardous::setHazardousWeight()
     * @uses Hazardous::setFactor()
     * @uses Hazardous::setClassificationCode()
     * @uses Hazardous::setPackingGroup()
     * @uses Hazardous::setSubsidiaryRisk()
     * @uses Hazardous::setTunnelRestrictionCode()
     * @uses Hazardous::setNetWeight()
     * @uses Hazardous::setNotOtherwiseSpecified()
     * @param string $identificationUnNo
     * @param string $identificationClass
     * @param string $packingCode
     * @param string $description
     * @param float $hazardousWeight
     * @param int $factor
     * @param string $classificationCode
     * @param string $packingGroup
     * @param string $subsidiaryRisk
     * @param string $tunnelRestrictionCode
     * @param float $netWeight
     * @param string $notOtherwiseSpecified
     */
    public function __construct($identificationUnNo = null, $identificationClass = null, $packingCode = null, $description = null, $hazardousWeight = null, $factor = null, $classificationCode = null, $packingGroup = null, $subsidiaryRisk = null, $tunnelRestrictionCode = null, $netWeight = null, $notOtherwiseSpecified = null)
    {
        $this
            ->setIdentificationUnNo($identificationUnNo)
            ->setIdentificationClass($identificationClass)
            ->setPackingCode($packingCode)
            ->setDescription($description)
            ->setHazardousWeight($hazardousWeight)
            ->setFactor($factor)
            ->setClassificationCode($classificationCode)
            ->setPackingGroup($packingGroup)
            ->setSubsidiaryRisk($subsidiaryRisk)
            ->setTunnelRestrictionCode($tunnelRestrictionCode)
            ->setNetWeight($netWeight)
            ->setNotOtherwiseSpecified($notOtherwiseSpecified);
    }
    /**
     * Get identificationUnNo value
     * @return string
     */
    public function getIdentificationUnNo()
    {
        return $this->identificationUnNo;
    }
    /**
     * Set identificationUnNo value
     * @param string $identificationUnNo
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setIdentificationUnNo($identificationUnNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationUnNo) && !is_string($identificationUnNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationUnNo, true), gettype($identificationUnNo)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($identificationUnNo) && mb_strlen($identificationUnNo) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($identificationUnNo)), __LINE__);
        }
        $this->identificationUnNo = $identificationUnNo;
        return $this;
    }
    /**
     * Get identificationClass value
     * @return string
     */
    public function getIdentificationClass()
    {
        return $this->identificationClass;
    }
    /**
     * Set identificationClass value
     * @param string $identificationClass
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setIdentificationClass($identificationClass = null)
    {
        // validation for constraint: string
        if (!is_null($identificationClass) && !is_string($identificationClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationClass, true), gettype($identificationClass)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($identificationClass) && mb_strlen($identificationClass) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($identificationClass)), __LINE__);
        }
        $this->identificationClass = $identificationClass;
        return $this;
    }
    /**
     * Get packingCode value
     * @return string
     */
    public function getPackingCode()
    {
        return $this->packingCode;
    }
    /**
     * Set packingCode value
     * @uses \dpd\Shipment\EnumType\PackingCode::valueIsValid()
     * @uses \dpd\Shipment\EnumType\PackingCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packingCode
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setPackingCode($packingCode = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\PackingCode::valueIsValid($packingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\PackingCode', is_array($packingCode) ? implode(', ', $packingCode) : var_export($packingCode, true), implode(', ', \dpd\Shipment\EnumType\PackingCode::getValidValues())), __LINE__);
        }
        $this->packingCode = $packingCode;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($description) && mb_strlen($description) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get hazardousWeight value
     * @return float
     */
    public function getHazardousWeight()
    {
        return $this->hazardousWeight;
    }
    /**
     * Set hazardousWeight value
     * @param float $hazardousWeight
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setHazardousWeight($hazardousWeight = null)
    {
        // validation for constraint: float
        if (!is_null($hazardousWeight) && !(is_float($hazardousWeight) || is_numeric($hazardousWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hazardousWeight, true), gettype($hazardousWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hazardousWeight) && mb_strlen(mb_substr($hazardousWeight, mb_strpos($hazardousWeight, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hazardousWeight, true), mb_strlen(mb_substr($hazardousWeight, mb_strpos($hazardousWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($hazardousWeight) && mb_strlen(preg_replace('/(\D)/', '', $hazardousWeight)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($hazardousWeight, true), mb_strlen(preg_replace('/(\D)/', '', $hazardousWeight))), __LINE__);
        }
        $this->hazardousWeight = $hazardousWeight;
        return $this;
    }
    /**
     * Get factor value
     * @return int
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param int $factor
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: int
        if (!is_null($factor) && !(is_int($factor) || ctype_digit($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($factor) && $factor > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($factor, true)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
    /**
     * Get classificationCode value
     * @return string|null
     */
    public function getClassificationCode()
    {
        return $this->classificationCode;
    }
    /**
     * Set classificationCode value
     * @param string $classificationCode
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setClassificationCode($classificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($classificationCode) && !is_string($classificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationCode, true), gettype($classificationCode)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($classificationCode) && mb_strlen($classificationCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($classificationCode)), __LINE__);
        }
        $this->classificationCode = $classificationCode;
        return $this;
    }
    /**
     * Get packingGroup value
     * @return string|null
     */
    public function getPackingGroup()
    {
        return $this->packingGroup;
    }
    /**
     * Set packingGroup value
     * @param string $packingGroup
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setPackingGroup($packingGroup = null)
    {
        // validation for constraint: string
        if (!is_null($packingGroup) && !is_string($packingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packingGroup, true), gettype($packingGroup)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($packingGroup) && mb_strlen($packingGroup) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($packingGroup)), __LINE__);
        }
        $this->packingGroup = $packingGroup;
        return $this;
    }
    /**
     * Get subsidiaryRisk value
     * @return string|null
     */
    public function getSubsidiaryRisk()
    {
        return $this->subsidiaryRisk;
    }
    /**
     * Set subsidiaryRisk value
     * @param string $subsidiaryRisk
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setSubsidiaryRisk($subsidiaryRisk = null)
    {
        // validation for constraint: string
        if (!is_null($subsidiaryRisk) && !is_string($subsidiaryRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidiaryRisk, true), gettype($subsidiaryRisk)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($subsidiaryRisk) && mb_strlen($subsidiaryRisk) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($subsidiaryRisk)), __LINE__);
        }
        $this->subsidiaryRisk = $subsidiaryRisk;
        return $this;
    }
    /**
     * Get tunnelRestrictionCode value
     * @return string|null
     */
    public function getTunnelRestrictionCode()
    {
        return $this->tunnelRestrictionCode;
    }
    /**
     * Set tunnelRestrictionCode value
     * @uses \dpd\Shipment\EnumType\TunnelRestrictionCode::valueIsValid()
     * @uses \dpd\Shipment\EnumType\TunnelRestrictionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunnelRestrictionCode
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setTunnelRestrictionCode($tunnelRestrictionCode = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\TunnelRestrictionCode::valueIsValid($tunnelRestrictionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\TunnelRestrictionCode', is_array($tunnelRestrictionCode) ? implode(', ', $tunnelRestrictionCode) : var_export($tunnelRestrictionCode, true), implode(', ', \dpd\Shipment\EnumType\TunnelRestrictionCode::getValidValues())), __LINE__);
        }
        $this->tunnelRestrictionCode = $tunnelRestrictionCode;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($netWeight) && mb_strlen(mb_substr($netWeight, mb_strpos($netWeight, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($netWeight, true), mb_strlen(mb_substr($netWeight, mb_strpos($netWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($netWeight) && mb_strlen(preg_replace('/(\D)/', '', $netWeight)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($netWeight, true), mb_strlen(preg_replace('/(\D)/', '', $netWeight))), __LINE__);
        }
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get notOtherwiseSpecified value
     * @return string|null
     */
    public function getNotOtherwiseSpecified()
    {
        return $this->notOtherwiseSpecified;
    }
    /**
     * Set notOtherwiseSpecified value
     * @param string $notOtherwiseSpecified
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public function setNotOtherwiseSpecified($notOtherwiseSpecified = null)
    {
        // validation for constraint: string
        if (!is_null($notOtherwiseSpecified) && !is_string($notOtherwiseSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notOtherwiseSpecified, true), gettype($notOtherwiseSpecified)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($notOtherwiseSpecified) && mb_strlen($notOtherwiseSpecified) > 150) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen($notOtherwiseSpecified)), __LINE__);
        }
        $this->notOtherwiseSpecified = $notOtherwiseSpecified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\Hazardous
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
