<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authenticationFault StructType
 * Meta information extracted from the WSDL
 * - documentation: The data structure for authentication errors.
 * @subpackage Structs
 */
class AuthenticationFault extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - documentation: The error code. Valid codes:NoAccessAuthenticationFault=-1NoRightsAuthenticationFault=-2
     * - base: xsd:string
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - documentation: The error message text.
     * - base: xsd:string
     * - maxLength: 255
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for authenticationFault
     * @uses AuthenticationFault::setErrorCode()
     * @uses AuthenticationFault::setErrorMessage()
     * @param string $errorCode
     * @param string $errorMessage
     */
    public function __construct($errorCode = null, $errorMessage = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \dpd\Shipment\StructType\AuthenticationFault
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \dpd\Shipment\StructType\AuthenticationFault
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($errorMessage) && mb_strlen($errorMessage) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($errorMessage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($errorMessage) && mb_strlen($errorMessage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\AuthenticationFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
