<?php

namespace dpd\Shipment\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Store ServiceType
 * @subpackage Services
 */
class Store extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dpd\Shipment\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\dpd\Shipment\StructType\Authentication $authentication, $nameSpace = 'http://dpd.com/common/service/types/Authentication/2.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named storeOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://dpd.com/common/service/types/Authentication/2.0
     * - SOAPHeaderTypes: \dpd\Shipment\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Stores up to 30 shipments and creates corresponding shipment documents.Sample request:<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns="http://dpd.com/common/service/types/Authentication/2.0"
     * xmlns:ns1="http://dpd.com/common/service/types/ShipmentService/4.3"> <soapenv:Header> <ns:authentication> <delisId><your delisId></delisId> <authToken><your authToken></authToken> <messageLanguage>de_DE</messageLanguage> </ns:authentication>
     * </soapenv:Header> <soapenv:Body> <ns1:storeOrders> <printOptions> <printOption> <outputFormat>PDF</outputFormat> <paperFormat>A4</paperFormat> </printOption> </printOptions> <order> <generalShipmentData>
     * <identificationNumber>77777</identificationNumber> <sendingDepot>0163</sendingDepot> <product>CL</product> <mpsCompleteDelivery>0</mpsCompleteDelivery> <sender> <name1>Abholer1</name1> <street>Strasse 1</street> <country>DE</country>
     * <zipCode>11111</zipCode> <city>Ort1</city> <customerNumber>12345679</customerNumber> </sender> <recipient> <name1>Test-Empfaenger</name1> <street>Test-Strasse</street> <state>BY</state> <country>DE</country> <zipCode>63741</zipCode>
     * <city>Aschaffenburg</city> </recipient> </generalShipmentData> <parcels> <parcelLabelNumber><your parcelLabelNumber></parcelLabelNumber> </parcels> <productAndServiceData> <orderType>consignment</orderType> </productAndServiceData> </order>
     * </ns1:storeOrders> </soapenv:Body></soapenv:Envelope>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dpd\Shipment\StructType\StoreOrders $parameters
     * @return \dpd\Shipment\StructType\StoreOrdersResponse|bool
     */
    public function storeOrders(\dpd\Shipment\StructType\StoreOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->storeOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dpd\Shipment\StructType\StoreOrdersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
