<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for OutputFormatType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Content of output format.Supported types are:PDF,ZPL,DPL,PDL,BARCODE_IMAGE,MULTIPAGE_IMAGE.
 * @subpackage Enumerations
 */
class OutputFormatType
{
    /**
     * Constant for value 'PDF'
     * @return string 'PDF'
     */
    const VALUE_PDF = 'PDF';
    /**
     * Constant for value 'ZPL'
     * @return string 'ZPL'
     */
    const VALUE_ZPL = 'ZPL';
    /**
     * Constant for value 'DPL'
     * @return string 'DPL'
     */
    const VALUE_DPL = 'DPL';
    /**
     * Constant for value 'PDL'
     * @return string 'PDL'
     */
    const VALUE_PDL = 'PDL';
    /**
     * Constant for value 'BARCODE_IMAGE'
     * @return string 'BARCODE_IMAGE'
     */
    const VALUE_BARCODE_IMAGE = 'BARCODE_IMAGE';
    /**
     * Constant for value 'MULTIPAGE_IMAGE'
     * @return string 'MULTIPAGE_IMAGE'
     */
    const VALUE_MULTIPAGE_IMAGE = 'MULTIPAGE_IMAGE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PDF
     * @uses self::VALUE_ZPL
     * @uses self::VALUE_DPL
     * @uses self::VALUE_PDL
     * @uses self::VALUE_BARCODE_IMAGE
     * @uses self::VALUE_MULTIPAGE_IMAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PDF,
            self::VALUE_ZPL,
            self::VALUE_DPL,
            self::VALUE_PDL,
            self::VALUE_BARCODE_IMAGE,
            self::VALUE_MULTIPAGE_IMAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
