<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for customsTerms EnumType
 * Meta information extracted from the WSDL
 * - documentation: Declares the customs terms.Possible values are:01 = DAP, cleared,02 = DDP, delivered duty paid (incl. duties and excl. taxes),03 = DDP, delivered duty paid (incl. duties and taxes),05 = ex works (EXW),06 = DAP.
 * @subpackage Enumerations
 */
class CustomsTerms
{
    /**
     * Constant for value '01'
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '05'
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Constant for value '06'
     * @return string '06'
     */
    const VALUE_06 = '06';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_05
     * @uses self::VALUE_06
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_05,
            self::VALUE_06,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
