<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for connectionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The connection type of the printer: serial or parallel connection.
 * @subpackage Enumerations
 */
class ConnectionType
{
    /**
     * Constant for value 'SERIAL'
     * @return string 'SERIAL'
     */
    const VALUE_SERIAL = 'SERIAL';
    /**
     * Constant for value 'PARALLEL'
     * @return string 'PARALLEL'
     */
    const VALUE_PARALLEL = 'PARALLEL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERIAL
     * @uses self::VALUE_PARALLEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERIAL,
            self::VALUE_PARALLEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
