<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles shipment response data.
 * @subpackage Structs
 */
class ShipmentResponse extends AbstractStructBase
{
    /**
     * The identificationNumber
     * Meta information extracted from the WSDL
     * - documentation: Serves as unique alphanumeric key of the shipment used by customer.
     * - base: xs:string
     * - maxLength: 999
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificationNumber;
    /**
     * The mpsId
     * Meta information extracted from the WSDL
     * - documentation: The shipment number for consignment data. If ordertype is pickup information, the shipment number is an internal database id, which is necessary for technical support requests at DPD. | The shipment number for consignment data.The
     * shipment number is only accepted if the parcel label number is allocated by customer.It starts with one of "MPS", "EXP" or "B2C", the last eight ciphers are the date in format yyyyMMdd.
     * - base: xs:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsId;
    /**
     * The parcelInformation
     * Meta information extracted from the WSDL
     * - documentation: Contains information about the single parcels.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\ParcelInformationType[]
     */
    public $parcelInformation;
    /**
     * The faults
     * Meta information extracted from the WSDL
     * - documentation: Contains information about errors during shipment order processing.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\FaultCodeType[]
     */
    public $faults;
    /**
     * Constructor method for shipmentResponse
     * @uses ShipmentResponse::setIdentificationNumber()
     * @uses ShipmentResponse::setMpsId()
     * @uses ShipmentResponse::setParcelInformation()
     * @uses ShipmentResponse::setFaults()
     * @param string $identificationNumber
     * @param string $mpsId
     * @param \dpd\Shipment\StructType\ParcelInformationType[] $parcelInformation
     * @param \dpd\Shipment\StructType\FaultCodeType[] $faults
     */
    public function __construct($identificationNumber = null, $mpsId = null, array $parcelInformation = array(), array $faults = array())
    {
        $this
            ->setIdentificationNumber($identificationNumber)
            ->setMpsId($mpsId)
            ->setParcelInformation($parcelInformation)
            ->setFaults($faults);
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNumber, true), gettype($identificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(999)
        if (!is_null($identificationNumber) && mb_strlen($identificationNumber) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 999', mb_strlen($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get mpsId value
     * @return string|null
     */
    public function getMpsId()
    {
        return $this->mpsId;
    }
    /**
     * Set mpsId value
     * @param string $mpsId
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public function setMpsId($mpsId = null)
    {
        // validation for constraint: string
        if (!is_null($mpsId) && !is_string($mpsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsId, true), gettype($mpsId)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($mpsId) && mb_strlen($mpsId) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($mpsId)), __LINE__);
        }
        $this->mpsId = $mpsId;
        return $this;
    }
    /**
     * Get parcelInformation value
     * @return \dpd\Shipment\StructType\ParcelInformationType[]|null
     */
    public function getParcelInformation()
    {
        return $this->parcelInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelInformationForArrayConstraintsFromSetParcelInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResponseParcelInformationItem) {
            // validation for constraint: itemType
            if (!$shipmentResponseParcelInformationItem instanceof \dpd\Shipment\StructType\ParcelInformationType) {
                $invalidValues[] = is_object($shipmentResponseParcelInformationItem) ? get_class($shipmentResponseParcelInformationItem) : sprintf('%s(%s)', gettype($shipmentResponseParcelInformationItem), var_export($shipmentResponseParcelInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcelInformation property can only contain items of type \dpd\Shipment\StructType\ParcelInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcelInformation value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\ParcelInformationType[] $parcelInformation
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public function setParcelInformation(array $parcelInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelInformationArrayErrorMessage = self::validateParcelInformationForArrayConstraintsFromSetParcelInformation($parcelInformation))) {
            throw new \InvalidArgumentException($parcelInformationArrayErrorMessage, __LINE__);
        }
        $this->parcelInformation = $parcelInformation;
        return $this;
    }
    /**
     * Add item to parcelInformation value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\ParcelInformationType $item
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public function addToParcelInformation(\dpd\Shipment\StructType\ParcelInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\Shipment\StructType\ParcelInformationType) {
            throw new \InvalidArgumentException(sprintf('The parcelInformation property can only contain items of type \dpd\Shipment\StructType\ParcelInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcelInformation[] = $item;
        return $this;
    }
    /**
     * Get faults value
     * @return \dpd\Shipment\StructType\FaultCodeType[]|null
     */
    public function getFaults()
    {
        return $this->faults;
    }
    /**
     * This method is responsible for validating the values passed to the setFaults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFaults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFaultsForArrayConstraintsFromSetFaults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResponseFaultsItem) {
            // validation for constraint: itemType
            if (!$shipmentResponseFaultsItem instanceof \dpd\Shipment\StructType\FaultCodeType) {
                $invalidValues[] = is_object($shipmentResponseFaultsItem) ? get_class($shipmentResponseFaultsItem) : sprintf('%s(%s)', gettype($shipmentResponseFaultsItem), var_export($shipmentResponseFaultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The faults property can only contain items of type \dpd\Shipment\StructType\FaultCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set faults value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\FaultCodeType[] $faults
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public function setFaults(array $faults = array())
    {
        // validation for constraint: array
        if ('' !== ($faultsArrayErrorMessage = self::validateFaultsForArrayConstraintsFromSetFaults($faults))) {
            throw new \InvalidArgumentException($faultsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($faults) && count($faults) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($faults)), __LINE__);
        }
        $this->faults = $faults;
        return $this;
    }
    /**
     * Add item to faults value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\FaultCodeType $item
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public function addToFaults(\dpd\Shipment\StructType\FaultCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\Shipment\StructType\FaultCodeType) {
            throw new \InvalidArgumentException(sprintf('The faults property can only contain items of type \dpd\Shipment\StructType\FaultCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->faults) && count($this->faults) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->faults)), __LINE__);
        }
        $this->faults[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\ShipmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
