<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for proactiveNotification StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles proactive notification data.
 * @subpackage Structs
 */
class ProactiveNotification extends AbstractStructBase
{
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $channel;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Data for proactive notification, e.g. telephone number, email address, etc.The data format for the proactive message types SMS, phone and FAX is as follows:+international country number#phone
     * numberExamples:+49#1725673423+49#01725673423 | Value for the chosen channel, i.e. the phone number or the e-mail address.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 1
     * @var string
     */
    public $value;
    /**
     * The rule
     * Meta information extracted from the WSDL
     * - documentation: Specifies for which events a notification is to be issued.Each event has a certain integer value. By adding the different values, it is possible to build combinations of events, e.g. notification for pick-up and delivery is 5.The
     * different values are:1 = Pick-up,2 = Non-delivery,4 = Delivery,8 = Inbound,16 = Out for delivery.So maximum value can be 31.
     * - base: xs:int
     * - maxInclusive: 31
     * - minOccurs: 1
     * @var int
     */
    public $rule;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Language of the proactive notification in ISO-3166-1 alpha-2 format (e.g. 'DE'). | Language of the notification in ISO 3166-1 alpha-2 format (e.g. 'DE').
     * - base: xs:string
     * - length: 2
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * Constructor method for proactiveNotification
     * @uses ProactiveNotification::setChannel()
     * @uses ProactiveNotification::setValue()
     * @uses ProactiveNotification::setRule()
     * @uses ProactiveNotification::setLanguage()
     * @param string $channel
     * @param string $value
     * @param int $rule
     * @param string $language
     */
    public function __construct($channel = null, $value = null, $rule = null, $language = null)
    {
        $this
            ->setChannel($channel)
            ->setValue($value)
            ->setRule($rule)
            ->setLanguage($language);
    }
    /**
     * Get channel value
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @uses \dpd\Shipment\EnumType\Channel::valueIsValid()
     * @uses \dpd\Shipment\EnumType\Channel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \dpd\Shipment\StructType\ProactiveNotification
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\Channel::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\Channel', is_array($channel) ? implode(', ', $channel) : var_export($channel, true), implode(', ', \dpd\Shipment\EnumType\Channel::getValidValues())), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get value value
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \dpd\Shipment\StructType\ProactiveNotification
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($value) && mb_strlen($value) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get rule value
     * @return int
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @param int $rule
     * @return \dpd\Shipment\StructType\ProactiveNotification
     */
    public function setRule($rule = null)
    {
        // validation for constraint: int
        if (!is_null($rule) && !(is_int($rule) || ctype_digit($rule))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rule, true), gettype($rule)), __LINE__);
        }
        // validation for constraint: maxInclusive(31)
        if (!is_null($rule) && $rule > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 31', var_export($rule, true)), __LINE__);
        }
        $this->rule = $rule;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \dpd\Shipment\StructType\ProactiveNotification
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($language) && mb_strlen($language) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\ProactiveNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
