<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printOption StructType
 * Meta information extracted from the WSDL
 * - documentation: Options how to return the parcel labels
 * @subpackage Structs
 */
class PrintOption extends AbstractStructBase
{
    /**
     * The outputFormat
     * Meta information extracted from the WSDL
     * - documentation: The format in which the parcel labels should be returned.PDF, BARCODE_IMAGE, MULTIPAGE_IMAGE as file output; DPL, PDL, ZPL for direct printing.In any case the output is base64 encoded.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $outputFormat;
    /**
     * The paperFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paperFormat;
    /**
     * The printer
     * Meta information extracted from the WSDL
     * - documentation: Information about the printer, if direct printing is enabled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\Printer
     */
    public $printer;
    /**
     * The startPosition
     * Meta information extracted from the WSDL
     * - documentation: The start position of the first parcellabel on the first page, if page format A4 is chosen. Ignored on other paperformats
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startPosition;
    /**
     * Constructor method for printOption
     * @uses PrintOption::setOutputFormat()
     * @uses PrintOption::setPaperFormat()
     * @uses PrintOption::setPrinter()
     * @uses PrintOption::setStartPosition()
     * @param string $outputFormat
     * @param string $paperFormat
     * @param \dpd\Shipment\StructType\Printer $printer
     * @param string $startPosition
     */
    public function __construct($outputFormat = null, $paperFormat = null, \dpd\Shipment\StructType\Printer $printer = null, $startPosition = null)
    {
        $this
            ->setOutputFormat($outputFormat)
            ->setPaperFormat($paperFormat)
            ->setPrinter($printer)
            ->setStartPosition($startPosition);
    }
    /**
     * Get outputFormat value
     * @return string
     */
    public function getOutputFormat()
    {
        return $this->outputFormat;
    }
    /**
     * Set outputFormat value
     * @uses \dpd\Shipment\EnumType\OutputFormatType::valueIsValid()
     * @uses \dpd\Shipment\EnumType\OutputFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputFormat
     * @return \dpd\Shipment\StructType\PrintOption
     */
    public function setOutputFormat($outputFormat = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\OutputFormatType::valueIsValid($outputFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\OutputFormatType', is_array($outputFormat) ? implode(', ', $outputFormat) : var_export($outputFormat, true), implode(', ', \dpd\Shipment\EnumType\OutputFormatType::getValidValues())), __LINE__);
        }
        $this->outputFormat = $outputFormat;
        return $this;
    }
    /**
     * Get paperFormat value
     * @return string|null
     */
    public function getPaperFormat()
    {
        return $this->paperFormat;
    }
    /**
     * Set paperFormat value
     * @uses \dpd\Shipment\EnumType\PaperFormat::valueIsValid()
     * @uses \dpd\Shipment\EnumType\PaperFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paperFormat
     * @return \dpd\Shipment\StructType\PrintOption
     */
    public function setPaperFormat($paperFormat = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\PaperFormat::valueIsValid($paperFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\PaperFormat', is_array($paperFormat) ? implode(', ', $paperFormat) : var_export($paperFormat, true), implode(', ', \dpd\Shipment\EnumType\PaperFormat::getValidValues())), __LINE__);
        }
        $this->paperFormat = $paperFormat;
        return $this;
    }
    /**
     * Get printer value
     * @return \dpd\Shipment\StructType\Printer|null
     */
    public function getPrinter()
    {
        return $this->printer;
    }
    /**
     * Set printer value
     * @param \dpd\Shipment\StructType\Printer $printer
     * @return \dpd\Shipment\StructType\PrintOption
     */
    public function setPrinter(\dpd\Shipment\StructType\Printer $printer = null)
    {
        $this->printer = $printer;
        return $this;
    }
    /**
     * Get startPosition value
     * @return string|null
     */
    public function getStartPosition()
    {
        return $this->startPosition;
    }
    /**
     * Set startPosition value
     * @uses \dpd\Shipment\EnumType\StartPosition::valueIsValid()
     * @uses \dpd\Shipment\EnumType\StartPosition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startPosition
     * @return \dpd\Shipment\StructType\PrintOption
     */
    public function setStartPosition($startPosition = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\StartPosition::valueIsValid($startPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\StartPosition', is_array($startPosition) ? implode(', ', $startPosition) : var_export($startPosition, true), implode(', ', \dpd\Shipment\EnumType\StartPosition::getValidValues())), __LINE__);
        }
        $this->startPosition = $startPosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\PrintOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
