<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles parcel information type data.
 * @subpackage Structs
 */
class ParcelInformationType extends AbstractStructBase
{
    /**
     * The parcelLabelNumber
     * Meta information extracted from the WSDL
     * - documentation: The parcel label number of the corresponding parcel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelLabelNumber;
    /**
     * The dpdReference
     * Meta information extracted from the WSDL
     * - documentation: The DPD reference for this parcel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dpdReference;
    /**
     * The output
     * Meta information extracted from the WSDL
     * - documentation: The content for the parcel.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\OutputType[]
     */
    public $output;
    /**
     * Constructor method for parcelInformationType
     * @uses ParcelInformationType::setParcelLabelNumber()
     * @uses ParcelInformationType::setDpdReference()
     * @uses ParcelInformationType::setOutput()
     * @param string $parcelLabelNumber
     * @param string $dpdReference
     * @param \dpd\Shipment\StructType\OutputType[] $output
     */
    public function __construct($parcelLabelNumber = null, $dpdReference = null, array $output = array())
    {
        $this
            ->setParcelLabelNumber($parcelLabelNumber)
            ->setDpdReference($dpdReference)
            ->setOutput($output);
    }
    /**
     * Get parcelLabelNumber value
     * @return string|null
     */
    public function getParcelLabelNumber()
    {
        return $this->parcelLabelNumber;
    }
    /**
     * Set parcelLabelNumber value
     * @param string $parcelLabelNumber
     * @return \dpd\Shipment\StructType\ParcelInformationType
     */
    public function setParcelLabelNumber($parcelLabelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelLabelNumber) && !is_string($parcelLabelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelLabelNumber, true), gettype($parcelLabelNumber)), __LINE__);
        }
        $this->parcelLabelNumber = $parcelLabelNumber;
        return $this;
    }
    /**
     * Get dpdReference value
     * @return string|null
     */
    public function getDpdReference()
    {
        return $this->dpdReference;
    }
    /**
     * Set dpdReference value
     * @param string $dpdReference
     * @return \dpd\Shipment\StructType\ParcelInformationType
     */
    public function setDpdReference($dpdReference = null)
    {
        // validation for constraint: string
        if (!is_null($dpdReference) && !is_string($dpdReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dpdReference, true), gettype($dpdReference)), __LINE__);
        }
        $this->dpdReference = $dpdReference;
        return $this;
    }
    /**
     * Get output value
     * @return \dpd\Shipment\StructType\OutputType[]|null
     */
    public function getOutput()
    {
        return $this->output;
    }
    /**
     * This method is responsible for validating the values passed to the setOutput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOutput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOutputForArrayConstraintsFromSetOutput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelInformationTypeOutputItem) {
            // validation for constraint: itemType
            if (!$parcelInformationTypeOutputItem instanceof \dpd\Shipment\StructType\OutputType) {
                $invalidValues[] = is_object($parcelInformationTypeOutputItem) ? get_class($parcelInformationTypeOutputItem) : sprintf('%s(%s)', gettype($parcelInformationTypeOutputItem), var_export($parcelInformationTypeOutputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The output property can only contain items of type \dpd\Shipment\StructType\OutputType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set output value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\OutputType[] $output
     * @return \dpd\Shipment\StructType\ParcelInformationType
     */
    public function setOutput(array $output = array())
    {
        // validation for constraint: array
        if ('' !== ($outputArrayErrorMessage = self::validateOutputForArrayConstraintsFromSetOutput($output))) {
            throw new \InvalidArgumentException($outputArrayErrorMessage, __LINE__);
        }
        $this->output = $output;
        return $this;
    }
    /**
     * Add item to output value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\OutputType $item
     * @return \dpd\Shipment\StructType\ParcelInformationType
     */
    public function addToOutput(\dpd\Shipment\StructType\OutputType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\Shipment\StructType\OutputType) {
            throw new \InvalidArgumentException(sprintf('The output property can only contain items of type \dpd\Shipment\StructType\OutputType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->output[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\ParcelInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
