<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for international StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles express international data.
 * @subpackage Structs
 */
class International extends AbstractStructBase
{
    /**
     * The parcelType
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the type of parcel is "documents" (allowed for air based destination only). Default value is false.
     * - minOccurs: 1
     * @var bool
     */
    public $parcelType;
    /**
     * The customsAmount
     * Meta information extracted from the WSDL
     * - documentation: Declared customs amount (in invoice currency) in total with two decimal digits without separator (e.g. 14.00 = 1400),for "documents" it is 0.
     * - base: xs:long
     * - maxInclusive: 999999999999999
     * - minOccurs: 1
     * @var int
     */
    public $customsAmount;
    /**
     * The customsCurrency
     * Meta information extracted from the WSDL
     * - documentation: Invoice currency code in ISO 4217 alpha-3 format.
     * - base: xs:string
     * - length: 3
     * - minOccurs: 1
     * @var string
     */
    public $customsCurrency;
    /**
     * The customsTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $customsTerms;
    /**
     * The customsAmountParcel
     * Meta information extracted from the WSDL
     * - documentation: Parcel value (in invoice currency) with two decimal digits without separator.
     * - base: xs:long
     * - maxInclusive: 999999999999999
     * - minOccurs: 0
     * @var int
     */
    public $customsAmountParcel;
    /**
     * The customsAmountExport
     * Meta information extracted from the WSDL
     * - documentation: Converted customs amount (in export currency) in total with two decimal digits without separator (14,00 = 1400),for "documents" it is set to 0.
     * - base: xs:long
     * - maxInclusive: 999999999999999
     * - minOccurs: 0
     * @var int
     */
    public $customsAmountExport;
    /**
     * The customsCurrencyExport
     * Meta information extracted from the WSDL
     * - documentation: Export currency code in ISO 4217 alpha-3 format.
     * - base: xs:string
     * - length: 3
     * - minOccurs: 0
     * @var string
     */
    public $customsCurrencyExport;
    /**
     * The customsContent
     * Meta information extracted from the WSDL
     * - documentation: Declares the content of the parcel. | Content.
     * - base: xs:string
     * - maxLength: 200
     * - minOccurs: 0
     * @var string
     */
    public $customsContent;
    /**
     * The customsTarif
     * Meta information extracted from the WSDL
     * - documentation: Declares the customs tarif number. | Customs tarif number.
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $customsTarif;
    /**
     * The customsPaper
     * Meta information extracted from the WSDL
     * - documentation: Declares accompanying documents without separator (e.g. "ABG"), composed by following values:A = Commercial invoice,B = Pro forma invoice,C = Export declaration,D = EUR1,E = EUR2,F = ATR,G = Delivery note,H = Third party billing,I =
     * T1 document.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $customsPaper;
    /**
     * The customsEnclosure
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the accompanying documents are at the parcel or not. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $customsEnclosure;
    /**
     * The customsInvoice
     * Meta information extracted from the WSDL
     * - documentation: Declares the invoice number.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $customsInvoice;
    /**
     * The customsInvoiceDate
     * Meta information extracted from the WSDL
     * - documentation: Declares the invoice date in format YYYYMMDD.
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $customsInvoiceDate;
    /**
     * The customsOrigin
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 2
     * - minOccurs: 0
     * @var string
     */
    public $customsOrigin;
    /**
     * The customsOrder
     * Meta information extracted from the WSDL
     * - documentation: Central customs order number for collective customs clearance.
     * - base: xs:string
     * - maxLength: 25
     * - minOccurs: 0
     * @var string
     */
    public $customsOrder;
    /**
     * The linehaul
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linehaul;
    /**
     * The shipMrn
     * Meta information extracted from the WSDL
     * - documentation: Movement reference number of the electronical export declaration.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $shipMrn;
    /**
     * The collectiveCustomsClearance
     * Meta information extracted from the WSDL
     * - documentation: Flag for determining collective customs clearance. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $collectiveCustomsClearance;
    /**
     * The invoicePosition
     * Meta information extracted from the WSDL
     * - documentation: Declares the invoice position.
     * - base: xs:int
     * - maxInclusive: 999999
     * - minOccurs: 0
     * @var int
     */
    public $invoicePosition;
    /**
     * The comment1
     * Meta information extracted from the WSDL
     * - documentation: Comment.
     * - base: xs:string
     * - maxLength: 70
     * - minOccurs: 0
     * @var string
     */
    public $comment1;
    /**
     * The comment2
     * Meta information extracted from the WSDL
     * - documentation: Second comment.
     * - base: xs:string
     * - maxLength: 70
     * - minOccurs: 0
     * @var string
     */
    public $comment2;
    /**
     * The commercialInvoiceConsigneeVatNumber
     * Meta information extracted from the WSDL
     * - documentation: Declares the commercial invoice consignee VAT number.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $commercialInvoiceConsigneeVatNumber;
    /**
     * The commercialInvoiceConsignee
     * Meta information extracted from the WSDL
     * - documentation: Contains address data of commercial invoice consignee.
     * @var \dpd\Shipment\StructType\Address
     */
    public $commercialInvoiceConsignee;
    /**
     * The commercialInvoiceConsignorVatNumber
     * Meta information extracted from the WSDL
     * - documentation: Declares the commercial invoice consignor VAT number.
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $commercialInvoiceConsignorVatNumber;
    /**
     * The commercialInvoiceConsignor
     * Meta information extracted from the WSDL
     * - documentation: Contains address data of commercial invoice consignor.
     * @var \dpd\Shipment\StructType\Address
     */
    public $commercialInvoiceConsignor;
    /**
     * The additionalInvoiceLines
     * Meta information extracted from the WSDL
     * - documentation: Contains additional invoice lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dpd\Shipment\StructType\AdditionalInvoiceLine[]
     */
    public $additionalInvoiceLines;
    /**
     * Constructor method for international
     * @uses International::setParcelType()
     * @uses International::setCustomsAmount()
     * @uses International::setCustomsCurrency()
     * @uses International::setCustomsTerms()
     * @uses International::setCustomsAmountParcel()
     * @uses International::setCustomsAmountExport()
     * @uses International::setCustomsCurrencyExport()
     * @uses International::setCustomsContent()
     * @uses International::setCustomsTarif()
     * @uses International::setCustomsPaper()
     * @uses International::setCustomsEnclosure()
     * @uses International::setCustomsInvoice()
     * @uses International::setCustomsInvoiceDate()
     * @uses International::setCustomsOrigin()
     * @uses International::setCustomsOrder()
     * @uses International::setLinehaul()
     * @uses International::setShipMrn()
     * @uses International::setCollectiveCustomsClearance()
     * @uses International::setInvoicePosition()
     * @uses International::setComment1()
     * @uses International::setComment2()
     * @uses International::setCommercialInvoiceConsigneeVatNumber()
     * @uses International::setCommercialInvoiceConsignee()
     * @uses International::setCommercialInvoiceConsignorVatNumber()
     * @uses International::setCommercialInvoiceConsignor()
     * @uses International::setAdditionalInvoiceLines()
     * @param bool $parcelType
     * @param int $customsAmount
     * @param string $customsCurrency
     * @param string $customsTerms
     * @param int $customsAmountParcel
     * @param int $customsAmountExport
     * @param string $customsCurrencyExport
     * @param string $customsContent
     * @param string $customsTarif
     * @param string $customsPaper
     * @param bool $customsEnclosure
     * @param string $customsInvoice
     * @param int $customsInvoiceDate
     * @param string $customsOrigin
     * @param string $customsOrder
     * @param string $linehaul
     * @param string $shipMrn
     * @param bool $collectiveCustomsClearance
     * @param int $invoicePosition
     * @param string $comment1
     * @param string $comment2
     * @param string $commercialInvoiceConsigneeVatNumber
     * @param \dpd\Shipment\StructType\Address $commercialInvoiceConsignee
     * @param string $commercialInvoiceConsignorVatNumber
     * @param \dpd\Shipment\StructType\Address $commercialInvoiceConsignor
     * @param \dpd\Shipment\StructType\AdditionalInvoiceLine[] $additionalInvoiceLines
     */
    public function __construct($parcelType = null, $customsAmount = null, $customsCurrency = null, $customsTerms = null, $customsAmountParcel = null, $customsAmountExport = null, $customsCurrencyExport = null, $customsContent = null, $customsTarif = null, $customsPaper = null, $customsEnclosure = null, $customsInvoice = null, $customsInvoiceDate = null, $customsOrigin = null, $customsOrder = null, $linehaul = null, $shipMrn = null, $collectiveCustomsClearance = null, $invoicePosition = null, $comment1 = null, $comment2 = null, $commercialInvoiceConsigneeVatNumber = null, \dpd\Shipment\StructType\Address $commercialInvoiceConsignee = null, $commercialInvoiceConsignorVatNumber = null, \dpd\Shipment\StructType\Address $commercialInvoiceConsignor = null, array $additionalInvoiceLines = array())
    {
        $this
            ->setParcelType($parcelType)
            ->setCustomsAmount($customsAmount)
            ->setCustomsCurrency($customsCurrency)
            ->setCustomsTerms($customsTerms)
            ->setCustomsAmountParcel($customsAmountParcel)
            ->setCustomsAmountExport($customsAmountExport)
            ->setCustomsCurrencyExport($customsCurrencyExport)
            ->setCustomsContent($customsContent)
            ->setCustomsTarif($customsTarif)
            ->setCustomsPaper($customsPaper)
            ->setCustomsEnclosure($customsEnclosure)
            ->setCustomsInvoice($customsInvoice)
            ->setCustomsInvoiceDate($customsInvoiceDate)
            ->setCustomsOrigin($customsOrigin)
            ->setCustomsOrder($customsOrder)
            ->setLinehaul($linehaul)
            ->setShipMrn($shipMrn)
            ->setCollectiveCustomsClearance($collectiveCustomsClearance)
            ->setInvoicePosition($invoicePosition)
            ->setComment1($comment1)
            ->setComment2($comment2)
            ->setCommercialInvoiceConsigneeVatNumber($commercialInvoiceConsigneeVatNumber)
            ->setCommercialInvoiceConsignee($commercialInvoiceConsignee)
            ->setCommercialInvoiceConsignorVatNumber($commercialInvoiceConsignorVatNumber)
            ->setCommercialInvoiceConsignor($commercialInvoiceConsignor)
            ->setAdditionalInvoiceLines($additionalInvoiceLines);
    }
    /**
     * Get parcelType value
     * @return bool
     */
    public function getParcelType()
    {
        return $this->parcelType;
    }
    /**
     * Set parcelType value
     * @param bool $parcelType
     * @return \dpd\Shipment\StructType\International
     */
    public function setParcelType($parcelType = null)
    {
        // validation for constraint: boolean
        if (!is_null($parcelType) && !is_bool($parcelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parcelType, true), gettype($parcelType)), __LINE__);
        }
        $this->parcelType = $parcelType;
        return $this;
    }
    /**
     * Get customsAmount value
     * @return int
     */
    public function getCustomsAmount()
    {
        return $this->customsAmount;
    }
    /**
     * Set customsAmount value
     * @param int $customsAmount
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsAmount($customsAmount = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmount) && !(is_int($customsAmount) || ctype_digit($customsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmount, true), gettype($customsAmount)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999999999)
        if (!is_null($customsAmount) && $customsAmount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999999999', var_export($customsAmount, true)), __LINE__);
        }
        $this->customsAmount = $customsAmount;
        return $this;
    }
    /**
     * Get customsCurrency value
     * @return string
     */
    public function getCustomsCurrency()
    {
        return $this->customsCurrency;
    }
    /**
     * Set customsCurrency value
     * @param string $customsCurrency
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsCurrency($customsCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($customsCurrency) && !is_string($customsCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsCurrency, true), gettype($customsCurrency)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($customsCurrency) && mb_strlen($customsCurrency) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($customsCurrency)), __LINE__);
        }
        $this->customsCurrency = $customsCurrency;
        return $this;
    }
    /**
     * Get customsTerms value
     * @return string
     */
    public function getCustomsTerms()
    {
        return $this->customsTerms;
    }
    /**
     * Set customsTerms value
     * @uses \dpd\Shipment\EnumType\CustomsTerms::valueIsValid()
     * @uses \dpd\Shipment\EnumType\CustomsTerms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customsTerms
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsTerms($customsTerms = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\CustomsTerms::valueIsValid($customsTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\CustomsTerms', is_array($customsTerms) ? implode(', ', $customsTerms) : var_export($customsTerms, true), implode(', ', \dpd\Shipment\EnumType\CustomsTerms::getValidValues())), __LINE__);
        }
        $this->customsTerms = $customsTerms;
        return $this;
    }
    /**
     * Get customsAmountParcel value
     * @return int|null
     */
    public function getCustomsAmountParcel()
    {
        return $this->customsAmountParcel;
    }
    /**
     * Set customsAmountParcel value
     * @param int $customsAmountParcel
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsAmountParcel($customsAmountParcel = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmountParcel) && !(is_int($customsAmountParcel) || ctype_digit($customsAmountParcel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmountParcel, true), gettype($customsAmountParcel)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999999999)
        if (!is_null($customsAmountParcel) && $customsAmountParcel > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999999999', var_export($customsAmountParcel, true)), __LINE__);
        }
        $this->customsAmountParcel = $customsAmountParcel;
        return $this;
    }
    /**
     * Get customsAmountExport value
     * @return int|null
     */
    public function getCustomsAmountExport()
    {
        return $this->customsAmountExport;
    }
    /**
     * Set customsAmountExport value
     * @param int $customsAmountExport
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsAmountExport($customsAmountExport = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmountExport) && !(is_int($customsAmountExport) || ctype_digit($customsAmountExport))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmountExport, true), gettype($customsAmountExport)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999999999)
        if (!is_null($customsAmountExport) && $customsAmountExport > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999999999', var_export($customsAmountExport, true)), __LINE__);
        }
        $this->customsAmountExport = $customsAmountExport;
        return $this;
    }
    /**
     * Get customsCurrencyExport value
     * @return string|null
     */
    public function getCustomsCurrencyExport()
    {
        return $this->customsCurrencyExport;
    }
    /**
     * Set customsCurrencyExport value
     * @param string $customsCurrencyExport
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsCurrencyExport($customsCurrencyExport = null)
    {
        // validation for constraint: string
        if (!is_null($customsCurrencyExport) && !is_string($customsCurrencyExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsCurrencyExport, true), gettype($customsCurrencyExport)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($customsCurrencyExport) && mb_strlen($customsCurrencyExport) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($customsCurrencyExport)), __LINE__);
        }
        $this->customsCurrencyExport = $customsCurrencyExport;
        return $this;
    }
    /**
     * Get customsContent value
     * @return string|null
     */
    public function getCustomsContent()
    {
        return $this->customsContent;
    }
    /**
     * Set customsContent value
     * @param string $customsContent
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsContent($customsContent = null)
    {
        // validation for constraint: string
        if (!is_null($customsContent) && !is_string($customsContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsContent, true), gettype($customsContent)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($customsContent) && mb_strlen($customsContent) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($customsContent)), __LINE__);
        }
        $this->customsContent = $customsContent;
        return $this;
    }
    /**
     * Get customsTarif value
     * @return string|null
     */
    public function getCustomsTarif()
    {
        return $this->customsTarif;
    }
    /**
     * Set customsTarif value
     * @param string $customsTarif
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsTarif($customsTarif = null)
    {
        // validation for constraint: string
        if (!is_null($customsTarif) && !is_string($customsTarif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTarif, true), gettype($customsTarif)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($customsTarif) && mb_strlen($customsTarif) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($customsTarif)), __LINE__);
        }
        $this->customsTarif = $customsTarif;
        return $this;
    }
    /**
     * Get customsPaper value
     * @return string|null
     */
    public function getCustomsPaper()
    {
        return $this->customsPaper;
    }
    /**
     * Set customsPaper value
     * @param string $customsPaper
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsPaper($customsPaper = null)
    {
        // validation for constraint: string
        if (!is_null($customsPaper) && !is_string($customsPaper)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsPaper, true), gettype($customsPaper)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($customsPaper) && mb_strlen($customsPaper) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($customsPaper)), __LINE__);
        }
        $this->customsPaper = $customsPaper;
        return $this;
    }
    /**
     * Get customsEnclosure value
     * @return bool|null
     */
    public function getCustomsEnclosure()
    {
        return $this->customsEnclosure;
    }
    /**
     * Set customsEnclosure value
     * @param bool $customsEnclosure
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsEnclosure($customsEnclosure = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsEnclosure) && !is_bool($customsEnclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsEnclosure, true), gettype($customsEnclosure)), __LINE__);
        }
        $this->customsEnclosure = $customsEnclosure;
        return $this;
    }
    /**
     * Get customsInvoice value
     * @return string|null
     */
    public function getCustomsInvoice()
    {
        return $this->customsInvoice;
    }
    /**
     * Set customsInvoice value
     * @param string $customsInvoice
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsInvoice($customsInvoice = null)
    {
        // validation for constraint: string
        if (!is_null($customsInvoice) && !is_string($customsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsInvoice, true), gettype($customsInvoice)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($customsInvoice) && mb_strlen($customsInvoice) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($customsInvoice)), __LINE__);
        }
        $this->customsInvoice = $customsInvoice;
        return $this;
    }
    /**
     * Get customsInvoiceDate value
     * @return int|null
     */
    public function getCustomsInvoiceDate()
    {
        return $this->customsInvoiceDate;
    }
    /**
     * Set customsInvoiceDate value
     * @param int $customsInvoiceDate
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsInvoiceDate($customsInvoiceDate = null)
    {
        // validation for constraint: int
        if (!is_null($customsInvoiceDate) && !(is_int($customsInvoiceDate) || ctype_digit($customsInvoiceDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsInvoiceDate, true), gettype($customsInvoiceDate)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($customsInvoiceDate) && $customsInvoiceDate > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($customsInvoiceDate, true)), __LINE__);
        }
        $this->customsInvoiceDate = $customsInvoiceDate;
        return $this;
    }
    /**
     * Get customsOrigin value
     * @return string|null
     */
    public function getCustomsOrigin()
    {
        return $this->customsOrigin;
    }
    /**
     * Set customsOrigin value
     * @param string $customsOrigin
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsOrigin($customsOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($customsOrigin) && !is_string($customsOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsOrigin, true), gettype($customsOrigin)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($customsOrigin) && mb_strlen($customsOrigin) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($customsOrigin)), __LINE__);
        }
        $this->customsOrigin = $customsOrigin;
        return $this;
    }
    /**
     * Get customsOrder value
     * @return string|null
     */
    public function getCustomsOrder()
    {
        return $this->customsOrder;
    }
    /**
     * Set customsOrder value
     * @param string $customsOrder
     * @return \dpd\Shipment\StructType\International
     */
    public function setCustomsOrder($customsOrder = null)
    {
        // validation for constraint: string
        if (!is_null($customsOrder) && !is_string($customsOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsOrder, true), gettype($customsOrder)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($customsOrder) && mb_strlen($customsOrder) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($customsOrder)), __LINE__);
        }
        $this->customsOrder = $customsOrder;
        return $this;
    }
    /**
     * Get linehaul value
     * @return string|null
     */
    public function getLinehaul()
    {
        return $this->linehaul;
    }
    /**
     * Set linehaul value
     * @uses \dpd\Shipment\EnumType\Linehaul::valueIsValid()
     * @uses \dpd\Shipment\EnumType\Linehaul::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $linehaul
     * @return \dpd\Shipment\StructType\International
     */
    public function setLinehaul($linehaul = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\Linehaul::valueIsValid($linehaul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\Linehaul', is_array($linehaul) ? implode(', ', $linehaul) : var_export($linehaul, true), implode(', ', \dpd\Shipment\EnumType\Linehaul::getValidValues())), __LINE__);
        }
        $this->linehaul = $linehaul;
        return $this;
    }
    /**
     * Get shipMrn value
     * @return string|null
     */
    public function getShipMrn()
    {
        return $this->shipMrn;
    }
    /**
     * Set shipMrn value
     * @param string $shipMrn
     * @return \dpd\Shipment\StructType\International
     */
    public function setShipMrn($shipMrn = null)
    {
        // validation for constraint: string
        if (!is_null($shipMrn) && !is_string($shipMrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipMrn, true), gettype($shipMrn)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($shipMrn) && mb_strlen($shipMrn) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($shipMrn)), __LINE__);
        }
        $this->shipMrn = $shipMrn;
        return $this;
    }
    /**
     * Get collectiveCustomsClearance value
     * @return bool|null
     */
    public function getCollectiveCustomsClearance()
    {
        return $this->collectiveCustomsClearance;
    }
    /**
     * Set collectiveCustomsClearance value
     * @param bool $collectiveCustomsClearance
     * @return \dpd\Shipment\StructType\International
     */
    public function setCollectiveCustomsClearance($collectiveCustomsClearance = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectiveCustomsClearance) && !is_bool($collectiveCustomsClearance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collectiveCustomsClearance, true), gettype($collectiveCustomsClearance)), __LINE__);
        }
        $this->collectiveCustomsClearance = $collectiveCustomsClearance;
        return $this;
    }
    /**
     * Get invoicePosition value
     * @return int|null
     */
    public function getInvoicePosition()
    {
        return $this->invoicePosition;
    }
    /**
     * Set invoicePosition value
     * @param int $invoicePosition
     * @return \dpd\Shipment\StructType\International
     */
    public function setInvoicePosition($invoicePosition = null)
    {
        // validation for constraint: int
        if (!is_null($invoicePosition) && !(is_int($invoicePosition) || ctype_digit($invoicePosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoicePosition, true), gettype($invoicePosition)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999)
        if (!is_null($invoicePosition) && $invoicePosition > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999', var_export($invoicePosition, true)), __LINE__);
        }
        $this->invoicePosition = $invoicePosition;
        return $this;
    }
    /**
     * Get comment1 value
     * @return string|null
     */
    public function getComment1()
    {
        return $this->comment1;
    }
    /**
     * Set comment1 value
     * @param string $comment1
     * @return \dpd\Shipment\StructType\International
     */
    public function setComment1($comment1 = null)
    {
        // validation for constraint: string
        if (!is_null($comment1) && !is_string($comment1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment1, true), gettype($comment1)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($comment1) && mb_strlen($comment1) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($comment1)), __LINE__);
        }
        $this->comment1 = $comment1;
        return $this;
    }
    /**
     * Get comment2 value
     * @return string|null
     */
    public function getComment2()
    {
        return $this->comment2;
    }
    /**
     * Set comment2 value
     * @param string $comment2
     * @return \dpd\Shipment\StructType\International
     */
    public function setComment2($comment2 = null)
    {
        // validation for constraint: string
        if (!is_null($comment2) && !is_string($comment2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment2, true), gettype($comment2)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($comment2) && mb_strlen($comment2) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($comment2)), __LINE__);
        }
        $this->comment2 = $comment2;
        return $this;
    }
    /**
     * Get commercialInvoiceConsigneeVatNumber value
     * @return string|null
     */
    public function getCommercialInvoiceConsigneeVatNumber()
    {
        return $this->commercialInvoiceConsigneeVatNumber;
    }
    /**
     * Set commercialInvoiceConsigneeVatNumber value
     * @param string $commercialInvoiceConsigneeVatNumber
     * @return \dpd\Shipment\StructType\International
     */
    public function setCommercialInvoiceConsigneeVatNumber($commercialInvoiceConsigneeVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($commercialInvoiceConsigneeVatNumber) && !is_string($commercialInvoiceConsigneeVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialInvoiceConsigneeVatNumber, true), gettype($commercialInvoiceConsigneeVatNumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($commercialInvoiceConsigneeVatNumber) && mb_strlen($commercialInvoiceConsigneeVatNumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($commercialInvoiceConsigneeVatNumber)), __LINE__);
        }
        $this->commercialInvoiceConsigneeVatNumber = $commercialInvoiceConsigneeVatNumber;
        return $this;
    }
    /**
     * Get commercialInvoiceConsignee value
     * @return \dpd\Shipment\StructType\Address|null
     */
    public function getCommercialInvoiceConsignee()
    {
        return $this->commercialInvoiceConsignee;
    }
    /**
     * Set commercialInvoiceConsignee value
     * @param \dpd\Shipment\StructType\Address $commercialInvoiceConsignee
     * @return \dpd\Shipment\StructType\International
     */
    public function setCommercialInvoiceConsignee(\dpd\Shipment\StructType\Address $commercialInvoiceConsignee = null)
    {
        $this->commercialInvoiceConsignee = $commercialInvoiceConsignee;
        return $this;
    }
    /**
     * Get commercialInvoiceConsignorVatNumber value
     * @return string|null
     */
    public function getCommercialInvoiceConsignorVatNumber()
    {
        return $this->commercialInvoiceConsignorVatNumber;
    }
    /**
     * Set commercialInvoiceConsignorVatNumber value
     * @param string $commercialInvoiceConsignorVatNumber
     * @return \dpd\Shipment\StructType\International
     */
    public function setCommercialInvoiceConsignorVatNumber($commercialInvoiceConsignorVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($commercialInvoiceConsignorVatNumber) && !is_string($commercialInvoiceConsignorVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialInvoiceConsignorVatNumber, true), gettype($commercialInvoiceConsignorVatNumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($commercialInvoiceConsignorVatNumber) && mb_strlen($commercialInvoiceConsignorVatNumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($commercialInvoiceConsignorVatNumber)), __LINE__);
        }
        $this->commercialInvoiceConsignorVatNumber = $commercialInvoiceConsignorVatNumber;
        return $this;
    }
    /**
     * Get commercialInvoiceConsignor value
     * @return \dpd\Shipment\StructType\Address|null
     */
    public function getCommercialInvoiceConsignor()
    {
        return $this->commercialInvoiceConsignor;
    }
    /**
     * Set commercialInvoiceConsignor value
     * @param \dpd\Shipment\StructType\Address $commercialInvoiceConsignor
     * @return \dpd\Shipment\StructType\International
     */
    public function setCommercialInvoiceConsignor(\dpd\Shipment\StructType\Address $commercialInvoiceConsignor = null)
    {
        $this->commercialInvoiceConsignor = $commercialInvoiceConsignor;
        return $this;
    }
    /**
     * Get additionalInvoiceLines value
     * @return \dpd\Shipment\StructType\AdditionalInvoiceLine[]|null
     */
    public function getAdditionalInvoiceLines()
    {
        return $this->additionalInvoiceLines;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInvoiceLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInvoiceLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInvoiceLinesForArrayConstraintsFromSetAdditionalInvoiceLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internationalAdditionalInvoiceLinesItem) {
            // validation for constraint: itemType
            if (!$internationalAdditionalInvoiceLinesItem instanceof \dpd\Shipment\StructType\AdditionalInvoiceLine) {
                $invalidValues[] = is_object($internationalAdditionalInvoiceLinesItem) ? get_class($internationalAdditionalInvoiceLinesItem) : sprintf('%s(%s)', gettype($internationalAdditionalInvoiceLinesItem), var_export($internationalAdditionalInvoiceLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The additionalInvoiceLines property can only contain items of type \dpd\Shipment\StructType\AdditionalInvoiceLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set additionalInvoiceLines value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\AdditionalInvoiceLine[] $additionalInvoiceLines
     * @return \dpd\Shipment\StructType\International
     */
    public function setAdditionalInvoiceLines(array $additionalInvoiceLines = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInvoiceLinesArrayErrorMessage = self::validateAdditionalInvoiceLinesForArrayConstraintsFromSetAdditionalInvoiceLines($additionalInvoiceLines))) {
            throw new \InvalidArgumentException($additionalInvoiceLinesArrayErrorMessage, __LINE__);
        }
        $this->additionalInvoiceLines = $additionalInvoiceLines;
        return $this;
    }
    /**
     * Add item to additionalInvoiceLines value
     * @throws \InvalidArgumentException
     * @param \dpd\Shipment\StructType\AdditionalInvoiceLine $item
     * @return \dpd\Shipment\StructType\International
     */
    public function addToAdditionalInvoiceLines(\dpd\Shipment\StructType\AdditionalInvoiceLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\Shipment\StructType\AdditionalInvoiceLine) {
            throw new \InvalidArgumentException(sprintf('The additionalInvoiceLines property can only contain items of type \dpd\Shipment\StructType\AdditionalInvoiceLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->additionalInvoiceLines[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\International
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
