<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generalShipmentData StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles general shipment data.
 * @subpackage Structs
 */
class GeneralShipmentData extends AbstractStructBase
{
    /**
     * The sendingDepot
     * Meta information extracted from the WSDL
     * - documentation: Sending depot for consignment, ordering depot for collection request, customer's depot for pickup information or creating/sending depot for dangerous goods.Four alphanumeric positions, including leading zeros, e.g. 0163.
     * - base: xs:string
     * - length: 4
     * - minOccurs: 1
     * @var string
     */
    public $sendingDepot;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The mpsId
     * Meta information extracted from the WSDL
     * - documentation: The shipment number for consignment data. If ordertype is pickup information, the shipment number is an internal database id, which is necessary for technical support requests at DPD. | The shipment number for consignment data.The
     * shipment number is only accepted if the parcel label number is allocated by customer.It starts with one of "MPS", "EXP" or "B2C", the last eight ciphers are the date in format yyyyMMdd.
     * - base: xs:string
     * - maxLength: 25
     * - minOccurs: 0
     * @var string
     */
    public $mpsId;
    /**
     * The cUser
     * Meta information extracted from the WSDL
     * - documentation: User ID of the person who made the entry.
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $cUser;
    /**
     * The mpsCustomerReferenceNumber1
     * Meta information extracted from the WSDL
     * - documentation: Consignment customer reference number 1 (maximal length 35), also customer reference number for collection request orders (maximal length 50).
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber1;
    /**
     * The mpsCustomerReferenceNumber2
     * Meta information extracted from the WSDL
     * - documentation: Consignment customer reference number 2.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber2;
    /**
     * The mpsCustomerReferenceNumber3
     * Meta information extracted from the WSDL
     * - documentation: Consignment customer reference number 3.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber3;
    /**
     * The mpsCustomerReferenceNumber4
     * Meta information extracted from the WSDL
     * - documentation: Consignment customer reference number 4.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber4;
    /**
     * The identificationNumber
     * Meta information extracted from the WSDL
     * - documentation: Serves as unique alphanumeric key of the shipment used by customer.
     * - base: xs:string
     * - maxLength: 999
     * - minOccurs: 0
     * @var string
     */
    public $identificationNumber;
    /**
     * The mpsCompleteDelivery
     * Meta information extracted from the WSDL
     * - documentation: Specifies if this shipment should be sent as complete delivery. Mandatory for COD. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $mpsCompleteDelivery;
    /**
     * The mpsCompleteDeliveryLabel
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the label for complete delivery is printed for pickup. Mandatory for COD. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $mpsCompleteDeliveryLabel;
    /**
     * The mpsVolume
     * Meta information extracted from the WSDL
     * - documentation: Volume per consignment in cm3 (without positions after the decimal point).
     * - base: xs:long
     * - maxInclusive: 999999999
     * - minOccurs: 0
     * @var int
     */
    public $mpsVolume;
    /**
     * The mpsWeight
     * Meta information extracted from the WSDL
     * - documentation: Shipment weight in grams rounded in 10 gram units without decimal point (e.g. 300 equals 3kg).
     * - base: xs:long
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $mpsWeight;
    /**
     * The mpsExpectedSendingDate
     * Meta information extracted from the WSDL
     * - documentation: Date when the shipment is expected to be transferred to the system. Format is YYYYMMDD.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01])
     * @var string
     */
    public $mpsExpectedSendingDate;
    /**
     * The mpsExpectedSendingTime
     * Meta information extracted from the WSDL
     * - documentation: Time when the shipment is expected to be transferred to the system. Format is HHMMSS.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: (([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9]))
     * @var string
     */
    public $mpsExpectedSendingTime;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - documentation: Consignment sender's address, collection request customer's address or pickup information customer's address.
     * @var \dpd\Shipment\StructType\Address
     */
    public $sender;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - documentation: Address of the recipient. For parcel shop delivery address of the real recipient.
     * @var \dpd\Shipment\StructType\Address
     */
    public $recipient;
    /**
     * Constructor method for generalShipmentData
     * @uses GeneralShipmentData::setSendingDepot()
     * @uses GeneralShipmentData::setProduct()
     * @uses GeneralShipmentData::setMpsId()
     * @uses GeneralShipmentData::setCUser()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber1()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber2()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber3()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber4()
     * @uses GeneralShipmentData::setIdentificationNumber()
     * @uses GeneralShipmentData::setMpsCompleteDelivery()
     * @uses GeneralShipmentData::setMpsCompleteDeliveryLabel()
     * @uses GeneralShipmentData::setMpsVolume()
     * @uses GeneralShipmentData::setMpsWeight()
     * @uses GeneralShipmentData::setMpsExpectedSendingDate()
     * @uses GeneralShipmentData::setMpsExpectedSendingTime()
     * @uses GeneralShipmentData::setSender()
     * @uses GeneralShipmentData::setRecipient()
     * @param string $sendingDepot
     * @param string $product
     * @param string $mpsId
     * @param string $cUser
     * @param string $mpsCustomerReferenceNumber1
     * @param string $mpsCustomerReferenceNumber2
     * @param string $mpsCustomerReferenceNumber3
     * @param string $mpsCustomerReferenceNumber4
     * @param string $identificationNumber
     * @param bool $mpsCompleteDelivery
     * @param bool $mpsCompleteDeliveryLabel
     * @param int $mpsVolume
     * @param int $mpsWeight
     * @param string $mpsExpectedSendingDate
     * @param string $mpsExpectedSendingTime
     * @param \dpd\Shipment\StructType\Address $sender
     * @param \dpd\Shipment\StructType\Address $recipient
     */
    public function __construct($sendingDepot = null, $product = null, $mpsId = null, $cUser = null, $mpsCustomerReferenceNumber1 = null, $mpsCustomerReferenceNumber2 = null, $mpsCustomerReferenceNumber3 = null, $mpsCustomerReferenceNumber4 = null, $identificationNumber = null, $mpsCompleteDelivery = null, $mpsCompleteDeliveryLabel = null, $mpsVolume = null, $mpsWeight = null, $mpsExpectedSendingDate = null, $mpsExpectedSendingTime = null, \dpd\Shipment\StructType\Address $sender = null, \dpd\Shipment\StructType\Address $recipient = null)
    {
        $this
            ->setSendingDepot($sendingDepot)
            ->setProduct($product)
            ->setMpsId($mpsId)
            ->setCUser($cUser)
            ->setMpsCustomerReferenceNumber1($mpsCustomerReferenceNumber1)
            ->setMpsCustomerReferenceNumber2($mpsCustomerReferenceNumber2)
            ->setMpsCustomerReferenceNumber3($mpsCustomerReferenceNumber3)
            ->setMpsCustomerReferenceNumber4($mpsCustomerReferenceNumber4)
            ->setIdentificationNumber($identificationNumber)
            ->setMpsCompleteDelivery($mpsCompleteDelivery)
            ->setMpsCompleteDeliveryLabel($mpsCompleteDeliveryLabel)
            ->setMpsVolume($mpsVolume)
            ->setMpsWeight($mpsWeight)
            ->setMpsExpectedSendingDate($mpsExpectedSendingDate)
            ->setMpsExpectedSendingTime($mpsExpectedSendingTime)
            ->setSender($sender)
            ->setRecipient($recipient);
    }
    /**
     * Get sendingDepot value
     * @return string
     */
    public function getSendingDepot()
    {
        return $this->sendingDepot;
    }
    /**
     * Set sendingDepot value
     * @param string $sendingDepot
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setSendingDepot($sendingDepot = null)
    {
        // validation for constraint: string
        if (!is_null($sendingDepot) && !is_string($sendingDepot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendingDepot, true), gettype($sendingDepot)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($sendingDepot) && mb_strlen($sendingDepot) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($sendingDepot)), __LINE__);
        }
        $this->sendingDepot = $sendingDepot;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \dpd\Shipment\EnumType\Product::valueIsValid()
     * @uses \dpd\Shipment\EnumType\Product::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\Shipment\EnumType\Product::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\Shipment\EnumType\Product', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \dpd\Shipment\EnumType\Product::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get mpsId value
     * @return string|null
     */
    public function getMpsId()
    {
        return $this->mpsId;
    }
    /**
     * Set mpsId value
     * @param string $mpsId
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsId($mpsId = null)
    {
        // validation for constraint: string
        if (!is_null($mpsId) && !is_string($mpsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsId, true), gettype($mpsId)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($mpsId) && mb_strlen($mpsId) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($mpsId)), __LINE__);
        }
        $this->mpsId = $mpsId;
        return $this;
    }
    /**
     * Get cUser value
     * @return string|null
     */
    public function getCUser()
    {
        return $this->cUser;
    }
    /**
     * Set cUser value
     * @param string $cUser
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setCUser($cUser = null)
    {
        // validation for constraint: string
        if (!is_null($cUser) && !is_string($cUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUser, true), gettype($cUser)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cUser) && mb_strlen($cUser) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($cUser)), __LINE__);
        }
        $this->cUser = $cUser;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber1 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber1()
    {
        return $this->mpsCustomerReferenceNumber1;
    }
    /**
     * Set mpsCustomerReferenceNumber1 value
     * @param string $mpsCustomerReferenceNumber1
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber1($mpsCustomerReferenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber1) && !is_string($mpsCustomerReferenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber1, true), gettype($mpsCustomerReferenceNumber1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mpsCustomerReferenceNumber1) && mb_strlen($mpsCustomerReferenceNumber1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($mpsCustomerReferenceNumber1)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber1 = $mpsCustomerReferenceNumber1;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber2 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber2()
    {
        return $this->mpsCustomerReferenceNumber2;
    }
    /**
     * Set mpsCustomerReferenceNumber2 value
     * @param string $mpsCustomerReferenceNumber2
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber2($mpsCustomerReferenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber2) && !is_string($mpsCustomerReferenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber2, true), gettype($mpsCustomerReferenceNumber2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($mpsCustomerReferenceNumber2) && mb_strlen($mpsCustomerReferenceNumber2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($mpsCustomerReferenceNumber2)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber2 = $mpsCustomerReferenceNumber2;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber3 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber3()
    {
        return $this->mpsCustomerReferenceNumber3;
    }
    /**
     * Set mpsCustomerReferenceNumber3 value
     * @param string $mpsCustomerReferenceNumber3
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber3($mpsCustomerReferenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber3) && !is_string($mpsCustomerReferenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber3, true), gettype($mpsCustomerReferenceNumber3)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($mpsCustomerReferenceNumber3) && mb_strlen($mpsCustomerReferenceNumber3) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($mpsCustomerReferenceNumber3)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber3 = $mpsCustomerReferenceNumber3;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber4 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber4()
    {
        return $this->mpsCustomerReferenceNumber4;
    }
    /**
     * Set mpsCustomerReferenceNumber4 value
     * @param string $mpsCustomerReferenceNumber4
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber4($mpsCustomerReferenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber4) && !is_string($mpsCustomerReferenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber4, true), gettype($mpsCustomerReferenceNumber4)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($mpsCustomerReferenceNumber4) && mb_strlen($mpsCustomerReferenceNumber4) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($mpsCustomerReferenceNumber4)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber4 = $mpsCustomerReferenceNumber4;
        return $this;
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNumber, true), gettype($identificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(999)
        if (!is_null($identificationNumber) && mb_strlen($identificationNumber) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 999', mb_strlen($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get mpsCompleteDelivery value
     * @return bool|null
     */
    public function getMpsCompleteDelivery()
    {
        return $this->mpsCompleteDelivery;
    }
    /**
     * Set mpsCompleteDelivery value
     * @param bool $mpsCompleteDelivery
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsCompleteDelivery($mpsCompleteDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($mpsCompleteDelivery) && !is_bool($mpsCompleteDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mpsCompleteDelivery, true), gettype($mpsCompleteDelivery)), __LINE__);
        }
        $this->mpsCompleteDelivery = $mpsCompleteDelivery;
        return $this;
    }
    /**
     * Get mpsCompleteDeliveryLabel value
     * @return bool|null
     */
    public function getMpsCompleteDeliveryLabel()
    {
        return $this->mpsCompleteDeliveryLabel;
    }
    /**
     * Set mpsCompleteDeliveryLabel value
     * @param bool $mpsCompleteDeliveryLabel
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsCompleteDeliveryLabel($mpsCompleteDeliveryLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($mpsCompleteDeliveryLabel) && !is_bool($mpsCompleteDeliveryLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mpsCompleteDeliveryLabel, true), gettype($mpsCompleteDeliveryLabel)), __LINE__);
        }
        $this->mpsCompleteDeliveryLabel = $mpsCompleteDeliveryLabel;
        return $this;
    }
    /**
     * Get mpsVolume value
     * @return int|null
     */
    public function getMpsVolume()
    {
        return $this->mpsVolume;
    }
    /**
     * Set mpsVolume value
     * @param int $mpsVolume
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsVolume($mpsVolume = null)
    {
        // validation for constraint: int
        if (!is_null($mpsVolume) && !(is_int($mpsVolume) || ctype_digit($mpsVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mpsVolume, true), gettype($mpsVolume)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($mpsVolume) && $mpsVolume > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($mpsVolume, true)), __LINE__);
        }
        $this->mpsVolume = $mpsVolume;
        return $this;
    }
    /**
     * Get mpsWeight value
     * @return int|null
     */
    public function getMpsWeight()
    {
        return $this->mpsWeight;
    }
    /**
     * Set mpsWeight value
     * @param int $mpsWeight
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsWeight($mpsWeight = null)
    {
        // validation for constraint: int
        if (!is_null($mpsWeight) && !(is_int($mpsWeight) || ctype_digit($mpsWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mpsWeight, true), gettype($mpsWeight)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($mpsWeight) && $mpsWeight > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($mpsWeight, true)), __LINE__);
        }
        $this->mpsWeight = $mpsWeight;
        return $this;
    }
    /**
     * Get mpsExpectedSendingDate value
     * @return string|null
     */
    public function getMpsExpectedSendingDate()
    {
        return $this->mpsExpectedSendingDate;
    }
    /**
     * Set mpsExpectedSendingDate value
     * @param string $mpsExpectedSendingDate
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsExpectedSendingDate($mpsExpectedSendingDate = null)
    {
        // validation for constraint: string
        if (!is_null($mpsExpectedSendingDate) && !is_string($mpsExpectedSendingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsExpectedSendingDate, true), gettype($mpsExpectedSendingDate)), __LINE__);
        }
        // validation for constraint: pattern([2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01]))
        if (!is_null($mpsExpectedSendingDate) && !preg_match('/[2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01])/', $mpsExpectedSendingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [2][0-9]{3}([0][0-9]|[1][0-2])(0[1-9]|[12][0-9]|3[01])', var_export($mpsExpectedSendingDate, true)), __LINE__);
        }
        $this->mpsExpectedSendingDate = $mpsExpectedSendingDate;
        return $this;
    }
    /**
     * Get mpsExpectedSendingTime value
     * @return string|null
     */
    public function getMpsExpectedSendingTime()
    {
        return $this->mpsExpectedSendingTime;
    }
    /**
     * Set mpsExpectedSendingTime value
     * @param string $mpsExpectedSendingTime
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setMpsExpectedSendingTime($mpsExpectedSendingTime = null)
    {
        // validation for constraint: string
        if (!is_null($mpsExpectedSendingTime) && !is_string($mpsExpectedSendingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsExpectedSendingTime, true), gettype($mpsExpectedSendingTime)), __LINE__);
        }
        // validation for constraint: pattern((([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9])))
        if (!is_null($mpsExpectedSendingTime) && !preg_match('/(([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9]))/', $mpsExpectedSendingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (([1][0-9]|[2][0-3]|[0][0-9])([0-5][0-9])([0-5][0-9]))|([0-9]([0-5][0-9])([0-5][0-9]))', var_export($mpsExpectedSendingTime, true)), __LINE__);
        }
        $this->mpsExpectedSendingTime = $mpsExpectedSendingTime;
        return $this;
    }
    /**
     * Get sender value
     * @return \dpd\Shipment\StructType\Address|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \dpd\Shipment\StructType\Address $sender
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setSender(\dpd\Shipment\StructType\Address $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get recipient value
     * @return \dpd\Shipment\StructType\Address|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param \dpd\Shipment\StructType\Address $recipient
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public function setRecipient(\dpd\Shipment\StructType\Address $recipient = null)
    {
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\GeneralShipmentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
