<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faultCodeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles fault code type data.
 * @subpackage Structs
 */
class FaultCodeType extends AbstractStructBase
{
    /**
     * The faultCode
     * Meta information extracted from the WSDL
     * - documentation: Possible error codes are:SHIPPING_1 - Pickup address is unknown for customer,SHIPPING_2 - Parcel label print fails,COMMON_1 - Unexpected runtime error,COMMON_2 - Mandatory input field is empty,COMMON_3 - Length of data for field does
     * not fit,COMMON_4 - Input data contains invalid special character,COMMON_5 - A swap parcel is ordered, but there is more than one parcel,COMMON_6 - Some input data field values result in an invalid combination,COMMON_7 - Input data contains invalid
     * value,COMMON_8 - A field is to be stored in database, but there is not database field mapped for it,DATABASE_6 - Transfer state of order is to be changed but order is already committed,DATABASE_7 - Update fails on database level during order
     * storing,DATABASE_8 - Delete fails on database level during rollback after some other error,DATABASE_21 - Order is to be inserted in databse, but has already a database id,DATABASE_22 - Order is to be committed after inserting, but there is no
     * database id for update given,DATABASE_24 - Feletion is necessary because of some other error, but no database id for record is given,MPSEXP_1 - Parcel label number is already in use,ROUTING_1 - No route could be found for depot and feature,ROUTING_2
     * - Invalid input data,ROUTING_3 - The connection to the database failed,ROUTING_4 - An internal failure occurs,ROUTING_5 - No depot could be found,ROUTING_6 - No pickup date was given,ROUTING_7 - Internal extension rule error,ROUTING_8 - Malformed zip
     * code,ROUTING_9 - Missing country code,ROUTING_10 - Missing routing place,ROUTING_11 - Missing service code,ROUTING_12 - Routing place error,ROUTING_13 - Sending date error,ROUTING_14 - Service code error,ROUTING_15 - Invalid relation of service
     * codes,ROUTING_16 - Unknown country code,ROUTING_17 - Unknown destination depot,ROUTING_18 - Unknown zip code,ROUTING_19 - Unknown routing place,ROUTING_20 - Unknown service code,ROUTING_21 - Invalid service code,ROUTING_21 - Parcel is labelled as
     * return parcel but returns is not possible,ROUTING_22 - Missing allow,ROUTING_23 - Missing routing place or destination depot.
     * @var string
     */
    public $faultCode;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - documentation: Message with detailed information for the fault (e.g. incorrect field).
     * @var string
     */
    public $message;
    /**
     * Constructor method for faultCodeType
     * @uses FaultCodeType::setFaultCode()
     * @uses FaultCodeType::setMessage()
     * @param string $faultCode
     * @param string $message
     */
    public function __construct($faultCode = null, $message = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setMessage($message);
    }
    /**
     * Get faultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->faultCode;
    }
    /**
     * Set faultCode value
     * @param string $faultCode
     * @return \dpd\Shipment\StructType\FaultCodeType
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        $this->faultCode = $faultCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \dpd\Shipment\StructType\FaultCodeType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\FaultCodeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
