<?php

namespace dpd\Shipment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for address StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles address data.
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - documentation: Name of address owner. For dangerous goods the maximum length is 50, otherwise always 35.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: Street of address owner. For dangerous goods the maximum length is 50, otherwise always 35.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: Country of address owner in ISO 3166-1 alpha-2 format (e.g. 'DE').
     * - base: xs:string
     * - length: 2
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - documentation: Zip code of address owner.
     * - base: xs:string
     * - maxLength: 9
     * - minOccurs: 1
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City/town of address owner. For dangerous goods the maximum length is 50, otherwise always 35.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - documentation: Second name of address owner.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $name2;
    /**
     * The houseNo
     * Meta information extracted from the WSDL
     * - documentation: House number of address owner.
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $houseNo;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - documentation: State of address owner in ISO 3166-2 code (e.g. BY = Bayern).
     * - base: xs:string
     * - length: 2
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The gln
     * Meta information extracted from the WSDL
     * - documentation: International location number of address owner.
     * - base: xs:long
     * - maxInclusive: 9999999999999
     * - minOccurs: 0
     * @var int
     */
    public $gln;
    /**
     * The customerNumber
     * Meta information extracted from the WSDL
     * - documentation: Customer number of address owner. Maximum length is 17 for consignment and pickup information, 11 for collection request.Mandatory for sender's address.
     * - base: xs:string
     * - maxLength: 17
     * - minOccurs: 0
     * @var string
     */
    public $customerNumber;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - documentation: Contact person of address owner.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $contact;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Phone number of address owner. Mandatory if phone is the chosen notification channel.If SMS notification is chosen, either mobile or phone must be filled. | Telephone number of the person authorised to accept the consignment. This
     * field is only used for delivery with ID-Check (types 2 and 5).
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The mobile
     * Meta information extracted from the WSDL
     * - documentation: Mobile phone number of address owner. If SMS notification is chosen, either mobile or phone must be filled.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $mobile;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - documentation: Fax number of address owner. No required data format.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: The email address including at minimum one "@" character as a delimiter between addresser and domain. The domain must include at minimum one "." as a delimiter between domain-name and domain-country.
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 5
     * - minOccurs: 0
     * - pattern: [\w\p{L}!#$%&'*+/=?^_`{|}~-]+(\.[\w\p{L}!#$%&'*+/=?^_`{|}~-]+)*@[\w][\w\p{L}\-]*(\.[\w\p{L}\-]+)*(\.[a-z]{2,16})
     * @var string
     */
    public $email;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - documentation: Comment on address owner.
     * - base: xs:string
     * - maxLength: 70
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The iaccount
     * Meta information extracted from the WSDL
     * - documentation: Account allocation or cost center (for VTG) of invoice data for consignments.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $iaccount;
    /**
     * Constructor method for address
     * @uses Address::setName1()
     * @uses Address::setStreet()
     * @uses Address::setCountry()
     * @uses Address::setZipCode()
     * @uses Address::setCity()
     * @uses Address::setName2()
     * @uses Address::setHouseNo()
     * @uses Address::setState()
     * @uses Address::setGln()
     * @uses Address::setCustomerNumber()
     * @uses Address::setContact()
     * @uses Address::setPhone()
     * @uses Address::setMobile()
     * @uses Address::setFax()
     * @uses Address::setEmail()
     * @uses Address::setComment()
     * @uses Address::setIaccount()
     * @param string $name1
     * @param string $street
     * @param string $country
     * @param string $zipCode
     * @param string $city
     * @param string $name2
     * @param string $houseNo
     * @param string $state
     * @param int $gln
     * @param string $customerNumber
     * @param string $contact
     * @param string $phone
     * @param string $mobile
     * @param string $fax
     * @param string $email
     * @param string $comment
     * @param string $iaccount
     */
    public function __construct($name1 = null, $street = null, $country = null, $zipCode = null, $city = null, $name2 = null, $houseNo = null, $state = null, $gln = null, $customerNumber = null, $contact = null, $phone = null, $mobile = null, $fax = null, $email = null, $comment = null, $iaccount = null)
    {
        $this
            ->setName1($name1)
            ->setStreet($street)
            ->setCountry($country)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setName2($name2)
            ->setHouseNo($houseNo)
            ->setState($state)
            ->setGln($gln)
            ->setCustomerNumber($customerNumber)
            ->setContact($contact)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email)
            ->setComment($comment)
            ->setIaccount($iaccount);
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \dpd\Shipment\StructType\Address
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name1) && mb_strlen($name1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \dpd\Shipment\StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($street) && mb_strlen($street) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \dpd\Shipment\StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($country) && mb_strlen($country) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \dpd\Shipment\StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($zipCode) && mb_strlen($zipCode) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \dpd\Shipment\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \dpd\Shipment\StructType\Address
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name2) && mb_strlen($name2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get houseNo value
     * @return string|null
     */
    public function getHouseNo()
    {
        return $this->houseNo;
    }
    /**
     * Set houseNo value
     * @param string $houseNo
     * @return \dpd\Shipment\StructType\Address
     */
    public function setHouseNo($houseNo = null)
    {
        // validation for constraint: string
        if (!is_null($houseNo) && !is_string($houseNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNo, true), gettype($houseNo)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($houseNo) && mb_strlen($houseNo) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($houseNo)), __LINE__);
        }
        $this->houseNo = $houseNo;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \dpd\Shipment\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($state) && mb_strlen($state) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get gln value
     * @return int|null
     */
    public function getGln()
    {
        return $this->gln;
    }
    /**
     * Set gln value
     * @param int $gln
     * @return \dpd\Shipment\StructType\Address
     */
    public function setGln($gln = null)
    {
        // validation for constraint: int
        if (!is_null($gln) && !(is_int($gln) || ctype_digit($gln))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gln, true), gettype($gln)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999)
        if (!is_null($gln) && $gln > 9999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999', var_export($gln, true)), __LINE__);
        }
        $this->gln = $gln;
        return $this;
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \dpd\Shipment\StructType\Address
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($customerNumber) && mb_strlen($customerNumber) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \dpd\Shipment\StructType\Address
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($contact) && mb_strlen($contact) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \dpd\Shipment\StructType\Address
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->mobile;
    }
    /**
     * Set mobile value
     * @param string $mobile
     * @return \dpd\Shipment\StructType\Address
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile) && mb_strlen($mobile) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile)), __LINE__);
        }
        $this->mobile = $mobile;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \dpd\Shipment\StructType\Address
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fax) && mb_strlen($fax) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \dpd\Shipment\StructType\Address
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($email) && mb_strlen($email) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: pattern([\w\p{L}!#$%&'*+/=?^_`{|}~-]+(\.[\w\p{L}!#$%&'*+/=?^_`{|}~-]+)*@[\w][\w\p{L}\-]*(\.[\w\p{L}\-]+)*(\.[a-z]{2,16}))
        if (!is_null($email) && !preg_match('/[\\w\\p{L}!#$%&\'*+\/=?^_`{|}~-]+(\\.[\\w\\p{L}!#$%&\'*+\/=?^_`{|}~-]+)*@[\\w][\\w\\p{L}\\-]*(\\.[\\w\\p{L}\\-]+)*(\\.[a-z]{2,16})/', $email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\w\p{L}!#$%&\'*+/=?^_`{|}~-]+(\.[\w\p{L}!#$%&\'*+/=?^_`{|}~-]+)*@[\w][\w\p{L}\-]*(\.[\w\p{L}\-]+)*(\.[a-z]{2,16})', var_export($email, true)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \dpd\Shipment\StructType\Address
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($comment) && mb_strlen($comment) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get iaccount value
     * @return string|null
     */
    public function getIaccount()
    {
        return $this->iaccount;
    }
    /**
     * Set iaccount value
     * @param string $iaccount
     * @return \dpd\Shipment\StructType\Address
     */
    public function setIaccount($iaccount = null)
    {
        // validation for constraint: string
        if (!is_null($iaccount) && !is_string($iaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iaccount, true), gettype($iaccount)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($iaccount) && mb_strlen($iaccount) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($iaccount)), __LINE__);
        }
        $this->iaccount = $iaccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\Shipment\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
