<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for startPosition EnumType
 * Meta information extracted from the WSDL
 * - documentation: Start positions
 * @subpackage Enumerations
 */
class StartPosition
{
    /**
     * Constant for value 'UPPER_LEFT'
     * Meta information extracted from the WSDL
     * - documentation: Print first label in the upper left of the A4 sheet.
     * @return string 'UPPER_LEFT'
     */
    const VALUE_UPPER_LEFT = 'UPPER_LEFT';
    /**
     * Constant for value 'UPPER_RIGHT'
     * Meta information extracted from the WSDL
     * - documentation: Print first label in the upper right of the A4 sheet.
     * @return string 'UPPER_RIGHT'
     */
    const VALUE_UPPER_RIGHT = 'UPPER_RIGHT';
    /**
     * Constant for value 'LOWER_LEFT'
     * Meta information extracted from the WSDL
     * - documentation: Print first label in the lower left of the A4 sheet.
     * @return string 'LOWER_LEFT'
     */
    const VALUE_LOWER_LEFT = 'LOWER_LEFT';
    /**
     * Constant for value 'LOWER_RIGHT'
     * Meta information extracted from the WSDL
     * - documentation: Print first label in the lower right of the A4 sheet.
     * @return string 'LOWER_RIGHT'
     */
    const VALUE_LOWER_RIGHT = 'LOWER_RIGHT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPPER_LEFT
     * @uses self::VALUE_UPPER_RIGHT
     * @uses self::VALUE_LOWER_LEFT
     * @uses self::VALUE_LOWER_RIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPPER_LEFT,
            self::VALUE_UPPER_RIGHT,
            self::VALUE_LOWER_LEFT,
            self::VALUE_LOWER_RIGHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
