<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for product EnumType
 * Meta information extracted from the WSDL
 * - documentation: Selection of product, exactly one per shipment, mandatory for consignment data. Possible values are:CL = DPD CLASSICE830 = DPD 8:30E10 = DPD 10:00E12 = DPD 12:00E18 = DPD 18:00IE2 = DPD EXPRESSMAIL = DPD International MailMAX = DPD
 * MAXPL = DPD PARCELLetterPL+ = DPD PARCELLetterPlusPM4 = DPD Priority
 * @subpackage Enumerations
 */
class Product
{
    /**
     * Constant for value 'CL'
     * @return string 'CL'
     */
    const VALUE_CL = 'CL';
    /**
     * Constant for value 'E830'
     * @return string 'E830'
     */
    const VALUE_E_830 = 'E830';
    /**
     * Constant for value 'E10'
     * @return string 'E10'
     */
    const VALUE_E_10 = 'E10';
    /**
     * Constant for value 'E12'
     * @return string 'E12'
     */
    const VALUE_E_12 = 'E12';
    /**
     * Constant for value 'E18'
     * @return string 'E18'
     */
    const VALUE_E_18 = 'E18';
    /**
     * Constant for value 'IE2'
     * @return string 'IE2'
     */
    const VALUE_IE_2 = 'IE2';
    /**
     * Constant for value 'MAIL'
     * @return string 'MAIL'
     */
    const VALUE_MAIL = 'MAIL';
    /**
     * Constant for value 'MAX'
     * @return string 'MAX'
     */
    const VALUE_MAX = 'MAX';
    /**
     * Constant for value 'PL'
     * @return string 'PL'
     */
    const VALUE_PL = 'PL';
    /**
     * Constant for value 'PL+'
     * @return string 'PL+'
     */
    const VALUE_PL_1 = 'PL+';
    /**
     * Constant for value 'PM4'
     * @return string 'PM4'
     */
    const VALUE_PM_4 = 'PM4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CL
     * @uses self::VALUE_E_830
     * @uses self::VALUE_E_10
     * @uses self::VALUE_E_12
     * @uses self::VALUE_E_18
     * @uses self::VALUE_IE_2
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_MAX
     * @uses self::VALUE_PL
     * @uses self::VALUE_PL_1
     * @uses self::VALUE_PM_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CL,
            self::VALUE_E_830,
            self::VALUE_E_10,
            self::VALUE_E_12,
            self::VALUE_E_18,
            self::VALUE_IE_2,
            self::VALUE_MAIL,
            self::VALUE_MAX,
            self::VALUE_PL,
            self::VALUE_PL_1,
            self::VALUE_PM_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
