<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for orderType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the shipment type.Possible values are:consignment,collection request order,pickup information.
 * @subpackage Enumerations
 */
class OrderType
{
    /**
     * Constant for value 'consignment'
     * @return string 'consignment'
     */
    const VALUE_CONSIGNMENT = 'consignment';
    /**
     * Constant for value 'collection request order'
     * @return string 'collection request order'
     */
    const VALUE_COLLECTION_REQUEST_ORDER = 'collection request order';
    /**
     * Constant for value 'pickup information'
     * @return string 'pickup information'
     */
    const VALUE_PICKUP_INFORMATION = 'pickup information';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONSIGNMENT
     * @uses self::VALUE_COLLECTION_REQUEST_ORDER
     * @uses self::VALUE_PICKUP_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONSIGNMENT,
            self::VALUE_COLLECTION_REQUEST_ORDER,
            self::VALUE_PICKUP_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
