<?php

namespace dpd\Shipment\EnumType;

/**
 * This class stands for linehaul EnumType
 * Meta information extracted from the WSDL
 * - documentation: Declares mode of line haul, possible values are "AI" for air or "RO" for road.
 * @subpackage Enumerations
 */
class Linehaul
{
    /**
     * Constant for value 'AI'
     * @return string 'AI'
     */
    const VALUE_AI = 'AI';
    /**
     * Constant for value 'RO'
     * @return string 'RO'
     */
    const VALUE_RO = 'RO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AI
     * @uses self::VALUE_RO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AI,
            self::VALUE_RO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
