<?php

namespace dpd\Shipment;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'storeOrders' => '\\dpd\\Shipment\\StructType\\StoreOrders',
            'storeOrdersResponse' => '\\dpd\\Shipment\\StructType\\StoreOrdersResponse',
            'storeOrdersResponseType' => '\\dpd\\Shipment\\StructType\\StoreOrdersResponseType',
            'shipmentResponse' => '\\dpd\\Shipment\\StructType\\ShipmentResponse',
            'shipmentServiceData' => '\\dpd\\Shipment\\StructType\\ShipmentServiceData',
            'generalShipmentData' => '\\dpd\\Shipment\\StructType\\GeneralShipmentData',
            'address' => '\\dpd\\Shipment\\StructType\\Address',
            'parcel' => '\\dpd\\Shipment\\StructType\\Parcel',
            'productAndServiceData' => '\\dpd\\Shipment\\StructType\\ProductAndServiceData',
            'international' => '\\dpd\\Shipment\\StructType\\International',
            'delivery' => '\\dpd\\Shipment\\StructType\\Delivery',
            'proactiveNotification' => '\\dpd\\Shipment\\StructType\\ProactiveNotification',
            'notification' => '\\dpd\\Shipment\\StructType\\Notification',
            'cod' => '\\dpd\\Shipment\\StructType\\Cod',
            'hazardous' => '\\dpd\\Shipment\\StructType\\Hazardous',
            'personalDelivery' => '\\dpd\\Shipment\\StructType\\PersonalDelivery',
            'pickup' => '\\dpd\\Shipment\\StructType\\Pickup',
            'parcelInformationType' => '\\dpd\\Shipment\\StructType\\ParcelInformationType',
            'faultCodeType' => '\\dpd\\Shipment\\StructType\\FaultCodeType',
            'higherInsurance' => '\\dpd\\Shipment\\StructType\\HigherInsurance',
            'parcelShopDelivery' => '\\dpd\\Shipment\\StructType\\ParcelShopDelivery',
            'printOptions' => '\\dpd\\Shipment\\StructType\\PrintOptions',
            'printOption' => '\\dpd\\Shipment\\StructType\\PrintOption',
            'printer' => '\\dpd\\Shipment\\StructType\\Printer',
            'additionalInvoiceLine' => '\\dpd\\Shipment\\StructType\\AdditionalInvoiceLine',
            'OutputType' => '\\dpd\\Shipment\\StructType\\OutputType',
            'authentication' => '\\dpd\\Shipment\\StructType\\Authentication',
            'authenticationFault' => '\\dpd\\Shipment\\StructType\\AuthenticationFault',
        );
    }
}
